--
--
-- register Specialization
--
-- # Author:  Heady
-- # date: 20.01.2019
-- # last update: 20.01.2019
--
-- > Not for commercial use  < --
--

local modDir = g_currentModDirectory;

ModEvent = {};



local modDescXML = loadXMLFile("modDesc", modDir .. "modDesc.xml");
local version = getXMLString(modDescXML, "modDesc.version");
local specFile = Utils.getFilename("SpeedControl.lua", modDir);


if g_specializationManager:getSpecializationByName("SpeedControl") == nil then

	local ret = g_specializationManager:addSpecialization("SpeedControl", "SpeedControl", specFile, true, nil);
	print("Mod:  register spec SpeedControl v"..tostring(version).." by Heady");
	
	for i, typeDef in pairs(g_vehicleTypeManager.vehicleTypes) do
		if typeDef ~= nil and i ~= "locomotive" then
			local isDrivable = false;
			local isEnterable = false;
			local hasMotor = false;
			local isOwnSpec = false;
			for name, spec in pairs(typeDef.specializationsByName) do
				if name == "drivable"  then
					isDrivable = true;
				elseif name == "motorized" then
					hasMotor = true;
				elseif name == "enterable" then
					isEnterable = true;
				elseif name == "SpeedControl" then
					isOwnSpec = true;
				end;
			end
			if ( isDrivable and isEnterable and hasMotor ) and not isOwnSpec then
				local obj = g_specializationManager:getSpecializationObjectByName("SpeedControl");						
				typeDef.specializationsByName["SpeedControl"] = obj;
				table.insert(typeDef.specializationNames, "SpeedControl");
				table.insert(typeDef.specializations, obj);
			end;
		end;
	end;
		
end;


function ModEvent:loadMap(name)	
end;

function ModEvent:deleteMap()
end;

function ModEvent:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEvent:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEvent:update(dt)
end;

function ModEvent:draw()
end;

--addModEventListener(ModEvent);
