--[[
Interface: 1.7.1.0 b10490

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 10.10.2018

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


UniversalPassengerExitEvent = {}

local UniversalPassengerExitEvent_mt = Class(UniversalPassengerExitEvent, Event)
InitEventClass(UniversalPassengerExitEvent, "UniversalPassengerExitEvent")

function UniversalPassengerExitEvent:emptyNew()
    local self = Event:new(UniversalPassengerExitEvent_mt)
    return self
end

function UniversalPassengerExitEvent:new(object, seatId, exitVehicleId)
    local self = UniversalPassengerExitEvent:emptyNew()

    self.object = object
    self.seatId = seatId
    self.exitVehicleId = exitVehicleId

    return self
end

function UniversalPassengerExitEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.seatId = streamReadUInt8(streamId)
    self.exitVehicleId = streamReadUInt8(streamId)

    self:run(connection)
end

function UniversalPassengerExitEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUInt8(streamId, self.seatId)
    streamWriteUInt8(streamId, self.exitVehicleId)
end

function UniversalPassengerExitEvent:run(connection)
    if not connection:getIsServer() then
        self.object:setConnectionToSeatId(connection, nil)
        g_server:broadcastEvent(UniversalPassengerExitEvent:new(self.object, self.seatId, self.exitVehicleId), nil, connection, self.object)
    end

    self.object:exitPassengerSeat(self.seatId, self.exitVehicleId)
end
