--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionFillEvent = {}

local AnimalPenExtensionFillEvent_mt = Class(AnimalPenExtensionFillEvent, Event)
InitEventClass(AnimalPenExtensionFillEvent, "AnimalPenExtensionFillEvent")

function AnimalPenExtensionFillEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionFillEvent_mt)
    return self
end

function AnimalPenExtensionFillEvent:new(animalPen, isActive)
    local self = AnimalPenExtensionFillEvent:emptyNew()

    self.animalPen = animalPen
    self.isActive = isActive

    return self
end

function AnimalPenExtensionFillEvent:readStream(streamId, connection)
    self.animalPen = NetworkUtil.readNodeObject(streamId)
    self.isActive = streamReadBool(streamId)

    self:run(connection)
end

function AnimalPenExtensionFillEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.animalPen)
    streamWriteBool(streamId, self.isActive)
end

function AnimalPenExtensionFillEvent:run(connection)
    if self.animalPen ~= nil then
        self.animalPen:setFillingState(self.isActive, true)

        if not connection:getIsServer() then
            g_server:broadcastEvent(self, false, connection, self.animalPen)
        end
    end
end

function AnimalPenExtensionFillEvent.sendEvent(animalPen, isActive, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(AnimalPenExtensionFillEvent:new(animalPen, isActive), nil, nil, animalPen)
        else
            g_client:getServerConnection():sendEvent(AnimalPenExtensionFillEvent:new(animalPen, isActive))
        end
    end
end
