--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.1.0.0 @ 01.10.2020 - Allow MP support for all commands (Admin / Server only!), added new command to control 'milkContractorPercent'.

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionConsoleCommands = {}
local AnimalPenExtensionConsoleCommands_mt = Class(AnimalPenExtensionConsoleCommands)

function AnimalPenExtensionConsoleCommands:new(isServer, isClient, buildId, versionString, customEnvironment, baseDirectory, manager)
    if manager == nil then
        return
    end

    local self = {}
    setmetatable(self, AnimalPenExtensionConsoleCommands_mt)

    self.isServer = isServer
    self.isClient = isClient

    self.buildId = buildId
    self.versionString = versionString

    self.customEnvironment = customEnvironment
    self.baseDirectory = baseDirectory

    self.manager = manager
    self.devModeActive = false

    return self
end

function AnimalPenExtensionConsoleCommands:load()
    if self.manager == nil then
        return
    end

    -- Testing only
    if self.isServer and self.devModeActive then
        addConsoleCommand("apeUpdatePartsColour", "Set the colour of the Universal Water Addon you are standing at!", "consoleCommandUpdatePartsColour", self)
    end

    addConsoleCommand("apeSetRandomDelay", "Activate or deactivate a Milk Sale random delay.", "consoleCommandSetRandomDelay", self)
    addConsoleCommand("apeSetRandomDelayPercent", "Set the random delay percent factor.", "consoleCommandSetRandomDelayPercent", self)
    addConsoleCommand("apeSetMilkContractorPercent", "Set the Milk Contractor Percent. This is the percentage charged on top of the flat cost of $500 based on the sale price of the milk.", "consoleCommandSetMilkContractorPercent", self)
    addConsoleCommand("apeGetCurrentState", "Print the current state of the 'AnimalPenExtensionManager'. Option: [true] If 'true' the this information will be also printed to the log file.", "consoleCommandGetCurrentState", self)
end

function AnimalPenExtensionConsoleCommands:delete()
    if self.isServer and self.devModeActive then
        removeConsoleCommand("apeUpdatePartsColour")
    end

    removeConsoleCommand("apeSetRandomDelay")
    removeConsoleCommand("apeSetRandomDelayPercent")
    removeConsoleCommand("apeSetMilkContractorPercent")
    removeConsoleCommand("apeGetCurrentState")
end

function AnimalPenExtensionConsoleCommands:consoleCommandGetCurrentState(doPrint)
    local scale = '\n'
    local waterPriceActive = self.manager.waterPriceScaleOverride > -1
    if waterPriceActive then
        scale = '  |  Scale Set: ' .. tostring(self.manager.waterPriceScaleOverride) .. '\n'
    end

    local price = '\n\n'
    local maintenanceActive = self.manager.maintenancePerDayOverride > -1
    if maintenanceActive then
        price = '  |  Price Set: ' .. tostring(self.manager.maintenancePerDayOverride) .. '\n\n'
    end

    local info = '\n- Animal Pen Extension Manager - Version: ' .. self.manager.versionString .. ' -\n\n' ..
        'Settings:\n    Water Addon: ' .. tostring(self.manager.waterAddonActive) .. '\n        - Purchase Override: ' .. tostring(self.manager.purchaseOverride) .. '\n' ..
        '        - Water Price Override: ' .. tostring(waterPriceActive) .. scale ..
        '        - Maintenance Price Override: ' .. tostring(maintenanceActive) ..  price ..
        '    Milk Addon: ' .. tostring(self.manager.milkAddonActive) .. '\n' ..
        '        - Contractor Base Fee: ' .. tostring(MilkSaleDialog.MILK_TRUCK_TRIP_FEE) .. '\n        - Contractor Percent: ' .. tostring(self.manager.milkContractorPercent) .. '\n\n' ..
        '    Chicken Addon: ' .. tostring(self.manager.chickenAddonActive) .. '\n\n' ..
        'Save Game:\n    Milk Addon:\n' ..
        '        - Random Delay: ' .. tostring(self.manager.randomDelayActive) .. '  |  Chance Of Delay: ' .. tostring(self.manager.chanceOfDelay) .. '%  |  Text ID: ' .. tostring(self.manager.delayTextId) .. '\n\n'

    if doPrint ~= nil and doPrint:lower() == "true" then
        print(info)
    else
        return info
    end

    return
end

function AnimalPenExtensionConsoleCommands:consoleCommandSetRandomDelay()
    local text = "AnimalPenExtension: 'consoleCommandSetRandomDelay' is an admin only command!"

    if self.isServer or g_currentMission ~= nil and g_currentMission.isMasterUser then
        local delayTextId = self.manager.delayTextId
        local randomDelayActive = self.manager.randomDelayActive

        if randomDelayActive then
            text = "AnimalPenExtension: (Milk Addon) Random Delay Deactivated!"
        else
            text = "AnimalPenExtension: (Milk Addon) Random Delay Activated!"
        end

        if self.isServer then
            if randomDelayActive then
                delayTextId = self.manager:getRandomTextId()
            end

            self.manager:setDelayData(not randomDelayActive, delayTextId, true)
        else
            g_client:getServerConnection():sendEvent(AnimalPenExtensionMilkSalesSettingsEvent:new(not randomDelayActive, self.manager.chanceOfDelay, self.manager.milkContractorPercent))
        end
    end

    return text
end

function AnimalPenExtensionConsoleCommands:consoleCommandSetRandomDelayPercent(percent)
    local text = "AnimalPenExtension: 'consoleCommandSetRandomDelayPercent' is an admin only command!"

    if self.isServer or g_currentMission ~= nil and g_currentMission.isMasterUser then
        local chanceOfDelay = tonumber(percent)

        if chanceOfDelay == nil then
            chanceOfDelay = MathUtil.clamp(self.manager:getDefaultDelayChance(), 0, 100)
            text = "AnimalPenExtension: (Milk Addon) No percent value given! Chance of Random Delay reset to default of " .. tostring(chanceOfDelay) .. "%."
        else
            chanceOfDelay = math.floor(MathUtil.clamp(chanceOfDelay, 0, 100))
            text = "AnimalPenExtension: (Milk Addon) Chance of Random Delay updated to " .. tostring(chanceOfDelay) .. "%."
        end

        if self.isServer then
            self.manager.chanceOfDelay = chanceOfDelay
            g_server:broadcastEvent(AnimalPenExtensionMilkSalesSettingsEvent:new(self.manager.randomDelayActive, chanceOfDelay, self.manager.milkContractorPercent), false)
        else
            g_client:getServerConnection():sendEvent(AnimalPenExtensionMilkSalesSettingsEvent:new(self.manager.randomDelayActive, chanceOfDelay, self.manager.milkContractorPercent))
        end
    end

    return text
end

function AnimalPenExtensionConsoleCommands:consoleCommandSetMilkContractorPercent(percent)
    local text = "AnimalPenExtension: 'consoleCommandSetMilkContractorPercent' is an admin only command!"

    if self.isServer or g_currentMission ~= nil and g_currentMission.isMasterUser then
        local milkContractorPercent = tonumber(percent)

        if milkContractorPercent == nil then
            milkContractorPercent = 5
            text = "AnimalPenExtension: (Milk Addon) No percent value given! Milk Contractor percent reset to default of 5%."
        else
            milkContractorPercent = math.floor(MathUtil.clamp(milkContractorPercent, 0, 100))
            text = "AnimalPenExtension: (Milk Addon) Milk Contractor percent updated to " .. tostring(milkContractorPercent) .. "%."
        end

        if self.isServer then
            self.manager.milkContractorPercent = milkContractorPercent
            g_server:broadcastEvent(AnimalPenExtensionMilkSalesSettingsEvent:new(self.manager.randomDelayActive, self.manager.chanceOfDelay, milkContractorPercent), false)
        else
            g_client:getServerConnection():sendEvent(AnimalPenExtensionMilkSalesSettingsEvent:new(self.manager.randomDelayActive, self.manager.chanceOfDelay, milkContractorPercent))
        end
    end

    return text
end

function AnimalPenExtensionConsoleCommands:consoleCommandUpdatePartsColour(colourIndex)
    if g_currentMission ~= nil and g_currentMission.controlledVehicle == nil then
        colourIndex = tonumber(colourIndex)

        if colourIndex ~= nil then
            local closestHusbandry

            for _, husbandry in pairs(g_currentMission.husbandries) do
                if husbandry.animalPenExtension ~= nil and husbandry.animalPenExtension.waterAddon ~= nil then
                    local triggerId = husbandry.animalPenExtension.waterAddon.triggerId
                    local distance = calcDistanceFrom(triggerId, getCamera())

                    if distance <= 6 then
                        if not husbandry.animalPenExtension.hasUniversalParts then
                            return "AnimalPenExtension: 'consoleCommandUpdatePartsColour'  No Universal Water Addon parts found at this animal pen!"
                        end

                        closestHusbandry = husbandry

                        break
                    end
                end
            end

            if closestHusbandry ~= nil then
                local index, name = closestHusbandry.animalPenExtension:setPartsColour(nil, colourIndex)

                if index > 0 then
                    if index ~= colourIndex then
                        return "AnimalPenExtension: 'consoleCommandUpdatePartsColour'  Failed to find a colour with index " .. tostring(colourIndex) .. "!"
                    end

                    return "AnimalPenExtension: 'consoleCommandUpdatePartsColour'  Colour " .. tostring(name) .. " has been set!"
                end

                return "AnimalPenExtension: 'consoleCommandUpdatePartsColour'  Failed to set a colour!"
            end

            return "AnimalPenExtension: 'consoleCommandUpdatePartsColour'  First stand in trigger of the valve to change colour on!"
        end

        return "AnimalPenExtension: 'consoleCommandUpdatePartsColour'  No colour index given!"
    end
end
