--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2020

Author: GtX | Andy
Date: 01.10.2020
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionMilkSalesSettingsEvent = {}

local AnimalPenExtensionMilkSalesSettingsEvent_mt = Class(AnimalPenExtensionMilkSalesSettingsEvent, Event)
InitEventClass(AnimalPenExtensionMilkSalesSettingsEvent, "AnimalPenExtensionMilkSalesSettingsEvent")

function AnimalPenExtensionMilkSalesSettingsEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionMilkSalesSettingsEvent_mt)
    return self
end

function AnimalPenExtensionMilkSalesSettingsEvent:new(randomDelayActive, chanceOfDelay, milkContractorPercent)
    local self = AnimalPenExtensionMilkSalesSettingsEvent:emptyNew()

    self.randomDelayActive = randomDelayActive
    self.chanceOfDelay = chanceOfDelay
    self.milkContractorPercent = milkContractorPercent

    return self
end

function AnimalPenExtensionMilkSalesSettingsEvent:readStream(streamId, connection)
    self.randomDelayActive = streamReadBool(streamId)
    self.chanceOfDelay = streamReadUInt8(streamId)
    self.milkContractorPercent = streamReadUInt8(streamId)

    self:run(connection)
end

function AnimalPenExtensionMilkSalesSettingsEvent:writeStream(streamId, connection)
    streamWriteBool(streamId, self.randomDelayActive)
    streamWriteUInt8(streamId, self.chanceOfDelay)
    streamWriteUInt8(streamId, self.milkContractorPercent)
end

function AnimalPenExtensionMilkSalesSettingsEvent:run(connection)
    if g_animalPenExtensionManager ~= nil then
        if g_currentMission:getIsServer() and not connection:getIsServer() and g_currentMission.userManager:getIsConnectionMasterUser(connection) then
            if self.randomDelayActive ~= g_animalPenExtensionManager.randomDelayActive then
                local delayTextId = g_animalPenExtensionManager.delayTextId

                if self.randomDelayActive then
                    delayTextId = g_animalPenExtensionManager:getRandomTextId()
                end

                g_animalPenExtensionManager:setDelayData(self.randomDelayActive, delayTextId, true)
            else
                g_server:broadcastEvent(self, false)
            end
        end

        g_animalPenExtensionManager.chanceOfDelay = self.chanceOfDelay
        g_animalPenExtensionManager.milkContractorPercent = self.milkContractorPercent
    end
end
