--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.1.0.0 @ 01.10.2020 - Update to support 'milkContractorPercent'.

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionJoinGameEvent = {}

local AnimalPenExtensionJoinGameEvent_mt = Class(AnimalPenExtensionJoinGameEvent, Event)
InitEventClass(AnimalPenExtensionJoinGameEvent, "AnimalPenExtensionJoinGameEvent")

function AnimalPenExtensionJoinGameEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionJoinGameEvent_mt)
    return self
end

function AnimalPenExtensionJoinGameEvent:new()
    local self = AnimalPenExtensionJoinGameEvent:emptyNew()
    return self
end

function AnimalPenExtensionJoinGameEvent:readStream(streamId, connection)
    if connection:getIsServer() then
        if streamReadBool(streamId) then
            local settings = {
                delayTextId = 1
            }

            settings.purchaseOverride = streamReadBool(streamId)
            settings.waterPriceScaleOverride = streamReadFloat32(streamId)
            settings.maintenancePerDayOverride = streamReadInt8(streamId)
            settings.chanceOfDelay = streamReadUInt8(streamId)
            settings.waterAddonActive = streamReadBool(streamId)
            settings.milkAddonActive = streamReadBool(streamId)
            settings.chickenAddonActive = streamReadBool(streamId)

            settings.randomDelayActive = streamReadBool(streamId)

            if settings.randomDelayActive then
                settings.delayTextId = streamReadUInt8(streamId)
            end

            settings.milkContractorPercent = streamReadUInt8(streamId)

            if g_animalPenExtensionManager ~= nil then
                g_animalPenExtensionManager:updateSettings(settings, true)
            end
        end
    end
end

function AnimalPenExtensionJoinGameEvent:writeStream(streamId, connection)
    if not connection:getIsServer() then
        if streamWriteBool(streamId, g_animalPenExtensionManager ~= nil) then
            local settings = g_animalPenExtensionManager:getCurrentSettings(false)

            streamWriteBool(streamId, settings.purchaseOverride)
            streamWriteFloat32(streamId, settings.waterPriceScaleOverride)
            streamWriteInt8(streamId, settings.maintenancePerDayOverride)
            streamWriteUInt8(streamId, settings.chanceOfDelay)
            streamWriteBool(streamId, settings.waterAddonActive)
            streamWriteBool(streamId, settings.milkAddonActive)
            streamWriteBool(streamId, settings.chickenAddonActive)

            if streamWriteBool(streamId, settings.randomDelayActive) then
                streamWriteUInt8(streamId, settings.delayTextId)
            end

            streamWriteUInt8(streamId, settings.milkContractorPercent)
        end
    end
end
