--[[
Interface: 1.6.0.0 b9173

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionDelayEvent = {}

local AnimalPenExtensionDelayEvent_mt = Class(AnimalPenExtensionDelayEvent, Event)
InitEventClass(AnimalPenExtensionDelayEvent, "AnimalPenExtensionDelayEvent")

function AnimalPenExtensionDelayEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionDelayEvent_mt)
    return self
end

function AnimalPenExtensionDelayEvent:new(randomDelayActive, delayTextId, forceUpdate)
    local self = AnimalPenExtensionDelayEvent:emptyNew()

    self.randomDelayActive = randomDelayActive
    self.delayTextId = delayTextId
    self.forceUpdate = forceUpdate

    return self
end

function AnimalPenExtensionDelayEvent:readStream(streamId, connection)
    self.randomDelayActive = streamReadBool(streamId)

    if self.randomDelayActive then
        self.delayTextId = streamReadUInt8(streamId)
    else
        self.delayTextId = 1
    end

    self.forceUpdate = streamReadBool(streamId)

    self:run(connection)
end

function AnimalPenExtensionDelayEvent:writeStream(streamId, connection)
    if streamWriteBool(streamId, self.randomDelayActive) then
        streamWriteUInt8(streamId, self.delayTextId)
    end

    streamWriteBool(streamId, self.forceUpdate)
end

function AnimalPenExtensionDelayEvent:run(connection)
    if g_animalPenExtensionManager ~= nil then
        g_animalPenExtensionManager:setDelayData(self.randomDelayActive, self.delayTextId, self.forceUpdate, true)
    end

    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false)
    end
end

function AnimalPenExtensionDelayEvent.sendEvent(randomDelayActive, delayTextId, forceUpdate, noEventSend)
    if noEventSend == nil or noEventSend == false then
        forceUpdate = Utils.getNoNil(forceUpdate, false)

        if g_currentMission:getIsServer() then
            g_server:broadcastEvent(AnimalPenExtensionDelayEvent:new(randomDelayActive, delayTextId, forceUpdate), false)
        else
            g_client:getServerConnection():sendEvent(AnimalPenExtensionDelayEvent:new(randomDelayActive, delayTextId, forceUpdate))
        end
    end
end


