VehicleInspector = {};

VehicleInspector.metadata = {
	interface = " FS19 1.x",
	title = " VehicleInspector",
	notes = " Zeigt/Ändert Vehicle Informationen/Bestände und vieles mehr in einem PDA Hud an",
	author = " (by HappyLooser)",
	version = " v1.5 Beta",
	datum = " 05.11.2016",
	update = " 10.03.2019",
	web = " no",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

--1.5
--update
--fix searchInvertColorByVehicleTypeName XML(not loaded),seeFillLevel XML(not loaded), careScale (cleanliness Horse %)
--new parkingVehicle Support
--test isTest (selectVehicle,JoinVehicle) (not Input Event) 1.49
VehicleInspector.modDir = g_currentModDirectory;
function VehicleInspector:loadMap(name)
	g_currentMission.vehicleInspector = VehicleInspector;	
	print("---loading".. tostring(VehicleInspector.metadata.title).. tostring(VehicleInspector.metadata.version).. tostring(VehicleInspector.metadata.author).. "---")
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;
	VehicleInspector.settingsDir = getUserProfileAppPath().. "modsSettings/VehicleInspector/";																					
	VehicleInspector.simple = {isOn=true,rebootXml=false,showInGameMapOn=true,showInGameMapOff=true,showHelpOn=false,showHelpOff=true,allTxtBold=false,vehicleSchemaPosY=0,defaultPosX=0.005,defaultPosY=0.99,defaultDownPosX=0.005,defaultDownPosY=0.01,defaultLastWidth=0,defaultLastHeight=0,defaultSize=0.010,lineNextTxtDistancePosX=0.001,lineDistancePosY=0.005,
	seeField=false,seeFieldNumber=false,seeSpeed=true,maxVehicleNameLength=10, maxFillNameLength=10, seeFillName=true,seeRealFillName=false,isFillLevel=false,isFillFull=false,seeFillLevel=true,isTrain=false,seeProzent=true,ownFarmVehicle=true,seePlayerName=true,seeVehicleName=false,seeVehicleSmallName=true;isHelper=true,isPlayer=true,isBlocking=true,isFuel=false,isWater=true,
	seeVehicleTypeName=false,isDamage=false,seeLastTotalAttached=true, isHorsePlayer=true, horseWarningColor=true, seeHorseCare=true, seeHorseDayRiding=true, seeHorseTodayRiding=true, seeHorseTodayRidingMin=true, seeHorseTodayRidingSec=true, seeHorseFitness=true, seeHorseHealth=true, isLeasing=true, leasingTxtLast=true, attachedLimit=4,
	seePlayerFirst=true,seeHelperFirst=true,seeHelperName=false,resetPosY=true,parkingVehicleModSupport=true,seeParkingVehicle=true,seeParkingVehicleMarker=true,joinParkingVehicle=false};
	if g_currentMission.hud ~= nil and g_currentMission.hud.vehicleSchema ~= nil and g_currentMission.hud.vehicleSchema.overlay ~= nil then VehicleInspector.simple.vehicleSchemaPosY = Utils.getNoNil(g_currentMission.hud.vehicleSchema.overlay.y, VehicleInspector.simple.defaultPosY);end;
	VehicleInspector.simple.tempPosY = 0.99; --for frozen display under F1 is Menu OFF (Testen)
	VehicleInspector.simple.tempDownPosY = 0.01; --for frozen display over MiniMap is MiniMap OFF (Testen)
	VehicleInspector.simple.isSelectVehicle = false;
	VehicleInspector.simple.selectVehicle = 1;
	VehicleInspector.simple.showMod = {		
		helpMenuOn=true;
		helpMenuOnAndInputEmpty=true;
		helpMenuOff=true;
		helpMenuOffAndInputEmpty=true;
		inGameMapOn=true;
		inGameMapOff=true;
		posDown = false;
	};
	VehicleInspector.simple.ownPos = {
		isOn = false;
		x = 0.005;
		y = 0.95;
		showHelpOnAutoFixX = false;
		showHelpOnAutoFixY = false;
		showHelpOnFixX = 0;
		showHelpOnFixY = 0;
		showHelpOffAutoFixX = false;
		showHelpOffAutoFixY = false;
		showHelpOffFixX = 0;
		showHelpOffFixY = 0;
		showInGameMapOnAutoFixX = false;
		showInGameMapOnAutoFixY = false;
		showInGameMapOnFixX = 0;
		showInGameMapOnFixY = 0;
		showInGameMapOffAutoFixX = false;
		showInGameMapOffAutoFixY = false;
		showInGameMapOffFixX = 0;
		showInGameMapOffFixY = 0;
		isDown = true;
		isRight = true;
		rightLengthAutoFixX = true;
	};
	VehicleInspector.simple.txt = {		
		separator = "|";
		speed = " km";
		field = "F ";
		horse = Utils.getNoNil(g_i18n:getText("ui_horseName"), "Horsename").. " ";
		fillNameToFillLevel = " ";  --is separator
		helperS = "H";
		otherT = "O";				
		playerS = "P";				
		otherSaEmpty = "! Empty !";
		otherSa = "^";				--is separator, see better Seeds/sowing etc.
		otherSaOrFill = "?";		--is separator, Seeds/sowing or Fill is Unknown etc.
		otherW = "! Water !";
		otherD = "! Damage !";
		otherB = "! Blocking !";
		otherFuelEmpty = "! Fuel Empty !";
		otherFull = "! Full !";
		otherL = "Leasing";
		horseHealth = "Health: ";
		horseFitness = Utils.getNoNil(g_i18n:getText("ui_horseFitness"), "Fitness:").. " ";
		horseTodayRiding = "Today Riding: ";
		horseDayRiding = Utils.getNoNil(g_i18n:getText("ui_horseDailyRiding"), "Days Riding:").. " ";
		horseTodayRidingHour = "h";
		horseCare = Utils.getNoNil(g_i18n:getText("statistic_cleanliness"), "Care:").. " ";
	};
	VehicleInspector.simple.searchInvert = {"sowing", "sowingmachine", "sprayer", "fertilizer", "manure", "potatoHarvesting", "fertilizerSpreaders", "manureSpreaders", "beetHarvesting", "harvesters "};
	VehicleInspector.simple.color = {
		seeBackground = true,
		default = {1, 1, 1, 1}, --white
		playerControlled = { 0/255, 255/255, 255/255, 1 }, --ls15
		anotherPlayerControlled = { 0/255, 255/255, 255/255, 0.80 }, --ls15Disabled
		isField = { 255/255, 0/255, 255/255, 1.00 }, --mangenta
		isWater = { 0/255, 0/255, 255/255, 1 }, --darkBlue
		isDamage = { 255/255, 165/255,  0/255, 1 } ,--orange
		isBlocking = { 255/255, 0/255, 0/255, 1 }, --red
		isLeasing = { 255/255, 020/255, 147/255, 1.00 }, --deepPink
		isBackground = { 0, 0, 0, 0.50 }, --black
		isSelectVehicle = { 240/255, 230/255, 140/255, 1.00 }, --khaki
		isSelectVehicleNotFarm = {255/255, 0/255, 0/255, 1.00 } --red
	};
	VehicleInspector.simple.color.prozent = {};
	VehicleInspector.simple.color.prozent[1] = {255/255, 	255/255, 	255/255,	1.00 }; --white
	VehicleInspector.simple.color.prozent[2] = {  0/255,	255/255, 	  0/255, 	1.00 }; --green
	VehicleInspector.simple.color.prozent[3] = {154/255, 	205/255,  	 50/255,	1.00 }; --yellowGreen
	VehicleInspector.simple.color.prozent[4] = {255/255, 	255/255, 	  0/255, 	1.00 }; --yellow
	VehicleInspector.simple.color.prozent[5] = {255/255, 	 65/255, 	  0/255, 	1.00 }; --orange
	VehicleInspector.simple.color.prozent[6] = {255/255,  	 28/255,   	  0/255, 	1.00 }; --orangeRed
	VehicleInspector.simple.color.prozent[7] = {255/255,	  0/255, 	  0/255, 	1.00 }; --red	
	VehicleInspector.simple.isDraw = {false, 0, 0, 0, modus=0}; --check for Keyboard input, 2=number,3=node,4=modus
	VehicleInspector.hlDebugMode = false;
	VehicleInspector.helpMenu = nil;
	VehicleInspector.inGameMapMenu = nil;
	VehicleInspector:getInGameDisplay();
	VehicleInspector:init();
	VehicleInspector.overlays = {};
	VehicleInspector.loadOverlays();
	VehicleInspector:setGetCfg(true);	
end;

function VehicleInspector:deleteMap()
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;
	VehicleInspector:setGetCfg(false);VehicleInspector:deleteOverlays();
end;

function VehicleInspector:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VehicleInspector:keyEvent(unicode, sym, modifier, isDown)
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;	
	if VehicleInspector:get_hl("getIngameMap", {}, "getIngameMap") or VehicleInspector:get_hl("getFullSize", {true, false}, "getFullSize") then return;end;
	if VehicleInspector.simple.rebootXml and VehicleInspector:get_hl("getFullSize", {false, true}, "getFullSize rebootXmlESC") and Input.isKeyPressed(Input.KEY_esc) then
		VehicleInspector:setGetCfg(true);	
	end;
	if VehicleInspector.simple.isSelectVehicle and VehicleInspector.simple.isDraw[1] then
		--if Input.isKeyPressed(Input.KEY_lshift) then
		if Input.isKeyPressed(Input.KEY_lshift) and Input.isKeyPressed(Input.KEY_down) then			
			if VehicleInspector.simple.selectVehicle >= VehicleInspector.simple.isDraw[2] then VehicleInspector.simple.selectVehicle = 1;else
			VehicleInspector.simple.selectVehicle = VehicleInspector.simple.selectVehicle+1;end;			
		elseif Input.isKeyPressed(Input.KEY_lshift)	and Input.isKeyPressed(Input.KEY_up) then			
			if VehicleInspector.simple.selectVehicle <= 1 then VehicleInspector.simple.selectVehicle = VehicleInspector.simple.isDraw[2];else
			VehicleInspector.simple.selectVehicle = VehicleInspector.simple.selectVehicle-1;end;			
		elseif Input.isKeyPressed(Input.KEY_lshift) and Input.isKeyPressed(Input.KEY_right) then			
			if VehicleInspector.simple.isDraw.modus == 0 then	VehicleInspector.simple.isDraw.modus = 1;else VehicleInspector.simple.isDraw.modus = 0;end;
			VehicleInspector.simple.selectVehicle = 1;VehicleInspector.simple.isDraw[2] = 0;VehicleInspector.simple.isDraw[3] = 0;			
			g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_OK, "VI Modus ".. tostring(VehicleInspector.simple.isDraw.modus), "VImodus");
			--if VehicleInspector.simple.isDraw.modus == 1 then 
			--	g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_CRITICAL, "VI Modus ".. tostring(VehicleInspector.simple.isDraw.modus), "VImodus");
			--	g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_CRITICAL, "NO SUPPORT", "VImodusWarning");
			--else
			--	g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_OK, "VI Modus ".. tostring(VehicleInspector.simple.isDraw.modus), "VImodus");
			--end;
		elseif Input.isKeyPressed(Input.KEY_lshift) and Input.isKeyPressed(Input.KEY_return) and VehicleInspector.simple.isDraw[3] ~= 0 then
			local vehicle = g_currentMission.vehicles[VehicleInspector.simple.isDraw[3]];
			if vehicle.rootNode ~= VehicleInspector.simple.isDraw[4] then return;end; --error check,later check over object please			
			if vehicle ~= nil and vehicle.isControlled then				
				g_currentMission:showBlinkingWarning("Vehicle is not free", 3000);
				return;
			elseif vehicle ~= nil then				
				if vehicle.spec_parkvehicle ~= nil and VehicleInspector.simple.parkingVehicleModSupport and not VehicleInspector.simple.joinParkingVehicle then
					local spec = vehicle.spec_parkvehicle;
					if spec.state[spec.uniqueUserId] then
						g_currentMission:showBlinkingWarning("Vehicle is Parking", 3000);
					else
						g_currentMission:requestToEnterVehicle(vehicle); --set Run Event
					end;
				else
					g_currentMission:requestToEnterVehicle(vehicle); --set Run Event
				end;				
			end;
		end;
		--end;
	end;
	if VehicleInspector.hlDebugMode and not VehicleInspector:get_hl("getFullSize", {true, true}, "getFullSize hlDebugMode") and Input.isKeyPressed(Input.KEY_f2)then
		if g_currentMission.hl.debug ~= nil then
			local a=1;		
			for key,value in pairs(g_currentMission.hl.debug) do
				for key1,value1 in pairs(value) do			
					print(tostring(a).. ".hl_Debug Error at ".. tostring(key).. " = ".. tostring(value1))			
					a=a+1;
				end;
			end;
		else
			print("1.hl_Debug NOT Found Error at ".. tostring(VehicleInspector.metadata.title))
		end;
	end;
end;

function VehicleInspector:update(dt)	
end;

function VehicleInspector:draw(dt)
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;
	if VehicleInspector:get_hl("getIngameMap", {}, "getIngameMap") or VehicleInspector:get_hl("getFullSize", {true, true}, "getFullSize") then return;end;
	--respect settings for other mods
	setTextAlignment(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
	if VehicleInspector.simple.isOn then 
		local seeDrawSimpleHelp = VehicleInspector:setCheckHelpMenuPosX_Y(VehicleInspector.simple.showMod.helpMenuOn, VehicleInspector.simple.showMod.helpMenuOff, g_gameSettings:getValue("showHelpMenu"));
		local seeDrawSimpleMap = VehicleInspector:setCheckInGameMapPosX_Y(VehicleInspector.simple.showMod.inGameMapOn, VehicleInspector.simple.showMod.inGameMapOff, VehicleInspector:get_hl("getIngameMapState", {}, "getIngameMapState hlDebugMode"));
		if VehicleInspector.simple.showMod.helpMenuOn and VehicleInspector.simple.showMod.helpMenuOff then 
			--VehicleInspector:setPosX_Y(true, true, g_gameSettings:getValue("showHelpMenu"));
			--seeDrawSimple = true;
		elseif VehicleInspector.simple.showMod.helpMenuOn then
			--VehicleInspector:setPosX_Y(true, false, g_gameSettings:getValue("showHelpMenu"));
			--seeDrawSimple = true;
		elseif 	VehicleInspector.simple.showMod.helpMenuOff then
			--VehicleInspector:setPosX_Y(false, true, g_gameSettings:getValue("showHelpMenu"));
			--seeDrawSimple = true;
		end;
		VehicleInspector.simple.isDraw[1] = seeDrawSimpleHelp and seeDrawSimpleMap;
		if seeDrawSimpleHelp and seeDrawSimpleMap then VehicleInspector:drawSimple();end;
	end;
	--respect settings for other mods
	setTextAlignment(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods	
end;
addModEventListener(VehicleInspector);

function VehicleInspector:setCheckHelpMenuPosX_Y(helpMenuOn, helpMenuOff, isShowHelpMenu)	
	if (helpMenuOn and isShowHelpMenu) then		
		if VehicleInspector.simple.showMod.helpMenuOnAndInputEmpty and VehicleInspector.helpMenu ~= nil and VehicleInspector.helpMenu.numUsedEntries == 0 then return false;end;
		if not VehicleInspector.simple.ownPos.isOn and VehicleInspector.helpMenu ~= nil and VehicleInspector.helpMenu.overlay ~= nil then
			VehicleInspector.simple.defaultPosY = VehicleInspector.helpMenu.overlay.y;
		end;
		return true;	
	elseif helpMenuOff and not isShowHelpMenu then
		if (g_currentMission.vehicleFruitHud ~= nil and g_currentMission.vehicleFruitHud.schemaPos == 1) or g_currentMission.vehicleFruitHud == nil then
			if not VehicleInspector.simple.ownPos.isOn then VehicleInspector.simple.defaultPosY = VehicleInspector.simple.vehicleSchemaPosY;end;
		elseif (g_currentMission.vehicleFruitHud ~= nil and g_currentMission.vehicleFruitHud.schemaPos > 1) or VehicleInspector.simple.resetPosY then
			VehicleInspector.simple.defaultPosY = VehicleInspector.simple.tempPosY;
		end;
		return true;
	elseif helpMenuOff and isShowHelpMenu and VehicleInspector.simple.showMod.helpMenuOffAndInputEmpty and VehicleInspector.helpMenu ~= nil and VehicleInspector.helpMenu.numUsedEntries == 0 then
			if not VehicleInspector.simple.ownPos.isOn then VehicleInspector.simple.defaultPosY = VehicleInspector.simple.vehicleSchemaPosY;end;		
		return true;
	end;
	return false;
end;

function VehicleInspector:setCheckInGameMapPosX_Y(inGameMapOn, inGameMapOff, isShowInGameMap)
	if (inGameMapOn and isShowInGameMap==0) then
		if not VehicleInspector.simple.ownPos.isOn and VehicleInspector.inGameMapMenu ~= nil and VehicleInspector.inGameMapMenu.overlay ~= nil then
			VehicleInspector.simple.defaultDownPosY = VehicleInspector.inGameMapMenu.overlay.y+VehicleInspector.inGameMapMenu.overlay.height+getTextHeight(VehicleInspector.inGameMapMenu.toggleMapSizeGlyph.iconSizeY, tostring("Gg"))+0.003; --0.003(balance) see Draw setBackground posY is posDown=true
		end;
		return true;
	elseif (inGameMapOff and isShowInGameMap==2) then
		if not VehicleInspector.simple.ownPos.isOn and VehicleInspector.simple.resetPosY then VehicleInspector.simple.defaultDownPosY = VehicleInspector.simple.tempDownPosY;end;
		return true;	
	end;
	return false;
end;

function VehicleInspector:drawSimple()	
	local size = VehicleInspector.simple.defaultSize;
	local posX = VehicleInspector.simple.defaultPosX;
	local posY = VehicleInspector.simple.defaultPosY;
	if VehicleInspector.simple.ownPos.isOn then posX = VehicleInspector.simple.ownPos.x;posY = VehicleInspector.simple.ownPos.y;
	elseif VehicleInspector.simple.showMod.posDown then posX = VehicleInspector.simple.defaultDownPosX;posY = VehicleInspector.simple.defaultDownPosY;end;
	local lineDistancePosY = VehicleInspector.simple.lineDistancePosY;
	local lineNextTxtDistancePosX = VehicleInspector.simple.lineNextTxtDistancePosX;	
	--respect settings for other mods
	setTextAlignment(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods		
	--local inVehicle, rootNode = g_currentMission.hl.isAvailable(g_currentMission.controlledVehicles, true);
	if g_currentMission ~= nil and g_currentMission.vehicles ~= nil then
		local txtHeight = 0;		
		local txtWidthDraw = 0;
		--local outputStringLimit = 4;
		local drawSeeLineOutputString = {};
		local drawNotSeeLineOutputString = {};
		local separator = VehicleInspector.simple.txt.separator;
		for a=1, #g_currentMission.vehicles do
			local vehicle = g_currentMission.vehicles[a];			
			if vehicle ~= nil and vehicle.getIsControlled ~= nil then --and vehicle.getCurrentHelper ~= nil then				
				drawSeeLineOutputString[#drawSeeLineOutputString+1] = {};
				drawSeeLineOutputString[#drawSeeLineOutputString].isSort = false;
				drawSeeLineOutputString[#drawSeeLineOutputString].vehicleNumber = a;
				drawSeeLineOutputString[#drawSeeLineOutputString].vehicleFarm = vehicle.ownerFarmId;
				drawSeeLineOutputString[#drawSeeLineOutputString].vehicleNode = vehicle.rootNode;
				drawSeeLineOutputString[#drawSeeLineOutputString].outputString = {};
				drawNotSeeLineOutputString[#drawNotSeeLineOutputString+1] = {}; --for allVehicle not active
				drawNotSeeLineOutputString[#drawNotSeeLineOutputString].vehicleNumber = a;
				drawNotSeeLineOutputString[#drawNotSeeLineOutputString].vehicleNode = vehicle.rootNode;
				drawNotSeeLineOutputString[#drawNotSeeLineOutputString].outputString = {};
				local txtWidth = 0;				
				local fillNameToFillLevel = VehicleInspector.simple.txt.fillNameToFillLevel;
				local helperS = VehicleInspector.simple.txt.helperS;
				local otherT = VehicleInspector.simple.txt.otherT;			
				local playerS = VehicleInspector.simple.txt.playerS;				
				local otherSaEmpty = VehicleInspector.simple.txt.otherSaEmpty;
				local otherSaOrFill = VehicleInspector.simple.txt.otherSaOrFill;
				local otherSa = VehicleInspector.simple.txt.otherSa;
				local otherW = VehicleInspector.simple.txt.otherW;
				local otherD = VehicleInspector.simple.txt.otherD;
				local otherB = VehicleInspector.simple.txt.otherB;
				local otherFuelEmpty = VehicleInspector.simple.txt.otherFuelEmpty;
				local otherFull = VehicleInspector.simple.txt.otherFull;
				local otherL = VehicleInspector.simple.txt.otherL;
				local horseHealthTxt = VehicleInspector.simple.txt.horseHealth;
				local horseFitnessTxt = VehicleInspector.simple.txt.horseFitness;
				local horseTodayRidingTxt = VehicleInspector.simple.txt.horseTodayRiding;
				local horseTodayRidingHourTxt = VehicleInspector.simple.txt.horseTodayRidingHour;
				local horseDayRidingTxt = VehicleInspector.simple.txt.horseDayRiding;
				local horseCareTxt = VehicleInspector.simple.txt.horseCare;
				local outputString = {};
				outputString[#outputString+1] = {};
				outputString[#outputString].txt = "";				
				if VehicleInspector.simple.seePlayerName and vehicle.getIsControlled(vehicle) then playerS = vehicle.getControllerName(vehicle);outputString[#outputString].isPlayer = false;end;
				--check performens getIsInUse
				if vehicle.getIsControlled(vehicle) and g_gameSettings.nickname == vehicle.getControllerName(vehicle) then outputString[#outputString].txtBold = true;outputString[#outputString].isPlayer = true;end;
				
				local seeLine = false;				
				local foundHorse = vehicle.specializationsByName ~= nil and vehicle.specializationsByName.rideable ~= nil and vehicle.spec_rideable ~= nil and vehicle.spec_rideable.animal ~= nil;
				local trainFound = false;
				if VehicleInspector.simple.isTrain and ((vehicle.viVehicleName ~= nil and vehicle.viVehicleName == "Train") or vehicle.trainSystem ~= nil) then seeLine = true;trainFound=true;outputString[#outputString].txt = outputString[#outputString].txt.. otherT;end;
				
				if VehicleInspector.simple.isHelper and vehicle.getCurrentHelper ~= nil and vehicle.getCurrentHelper(vehicle) then 
					local currentHelper = vehicle.getCurrentHelper(vehicle);					
					local helperName = "";
					if VehicleInspector.simple.seeHelperName then
						if currentHelper ~= nil then helperName = Utils.getNoNil(currentHelper.name, "");end;
						if string.len(helperS) > 0 and string.len(helperName) > 0 then helperName = "(".. helperName.. ")";end;
					else
						helperName = "";
					end;
					seeLine = true;outputString[#outputString].txt = outputString[#outputString].txt.. helperS.. helperName;outputString[#outputString].isHelper = true;
				end;
				if VehicleInspector.simple.isPlayer and vehicle.getIsControlled(vehicle) then 
					if not foundHorse or (foundHorse and VehicleInspector.simple.isHorsePlayer) then
						seeLine = true;												
						local sepHelperPlayer = "+";
						if string.len(playerS) <= 0 then sepHelperPlayer = "";end;
						if string.len(outputString[#outputString].txt) > 0 then outputString[#outputString].txt = outputString[#outputString].txt.. sepHelperPlayer;end;
						outputString[#outputString].txt = outputString[#outputString].txt.. playerS;outputString[#outputString].txtColor = VehicleInspector.simple.color.playerControlled; 
						if VehicleInspector.simple.allTxtBold and g_gameSettings.nickname ~= vehicle.getControllerName(vehicle) then outputString[#outputString].txtColor = VehicleInspector.simple.color.anotherPlayerControlled;end;
					end;
				end;				 
				
				-------
				--if not trainFound and VehicleInspector.simple.ownFarmVehicle and FarmManager ~= nil then --FarmManager is LS Bug check before
				--	local playerFarm = FarmManager.getFarmByUserId(g_farmManager, g_currentMission.playerUserId)
				--	if playerFarm ~= nil and type(playerFarm) == "table" and vehicle.ownerFarmId ~= playerFarm.farmId then seeLine = false;end;					
				--end;
				local isOwnFarmVehicle = g_currentMission.player.farmId == vehicle.ownerFarmId;
				if not trainFound and VehicleInspector.simple.ownFarmVehicle then --better not 100%					
					if not isOwnFarmVehicle then seeLine = false;end;					
				end;
				-------
				local seeLineFillLevelOrFull = false;
				local seeLineParkingVehicle = not foundHorse and not seeLine and vehicle.spec_parkvehicle ~= nil and VehicleInspector.simple.parkingVehicleModSupport and VehicleInspector.simple.seeParkingVehicle;
				local seeAllVehicle = false; ---next update
				local seeVehicleWithTrailer = false; --next update
				local seeVehicleWithAttached = false; --next update
				if not seeLine and (VehicleInspector.simple.isFillLevel or VehicleInspector.simple.isFillFull) then seeLineFillLevelOrFull = true;end;				
				
				--separate function check FillLevel for isFillFull and isFillLevel
				local attach, attachedSprayerAnd = VehicleInspector:getAttachedAndSprayerAnd(vehicle, 1);
				local foundFirstFillOrTxt = false; --if true then ignore isBlocking 
				function getFillLevel()
					local fillLevelTable = {};
					local foundFillFull = false;
					local foundFillLevel = false;
					if vehicle.getFillLevelInformation ~= nil then
						vehicle:getFillLevelInformation(fillLevelTable);
						for _,fillLevelVehicle in pairs(fillLevelTable) do
							if fillLevelVehicle.fillLevel > 0 then
								foundFillLevel = true;
								outputString[#outputString+1] = {};
								local typeName = Utils.getNoNil(string.lower(vehicle.typeName), "Unknown");
								local invertProzent = VehicleInspector:isInvertFill(typeName) or (attachedSprayerAnd > 0 and attach == 1) or (attachedSprayerAnd == attach);--string.find(typeName, "sowing") or string.find(typeName, "sprayer") or string.find(typeName, "manure") or string.find(typeName, "fertilizer") or attachedSprayerAnd > 0;
								if VehicleInspector.simple.seeFillLevel then
									outputString[#outputString].txt = string.format("%1.0f", Utils.getNoNil(fillLevelVehicle.fillLevel, 0));									
									if fillLevelVehicle.capacity > 0 then
										if (attachedSprayerAnd <= 1 and attach == 1) or (attachedSprayerAnd == attach) then --Unknown Seeds or Fill etc.
											local prozent = VehicleInspector:get_hl("getProzentFillLevel", {fillLevelVehicle.fillLevel, fillLevelVehicle.capacity, false}, "Vehicle ProzentFillLevel aString"); 
											if prozent ~= nil and prozent == "number" and tonumber(prozent) >= 100 then foundFillFull = true;end;
											local color, isOkay = VehicleInspector:get_hl("getProzentColor", {prozent, invertProzent}, "Vehicle FillLevel/Capacity FillLevel Color"); 
											if not isOkay then color = 1;end;
											outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[color];
											if color == 7 then
												table.insert(outputString, 1, {});
												foundFirstFillOrTxt = true;
												outputString[1].txt = otherFull;
												if invertProzent then outputString[1].txt = otherSaEmpty;end;
												outputString[1].txtColor = VehicleInspector.simple.color.prozent[color]; --Full or Empty
												outputString[1].txtBold = true;
											end;
										end;
									end;
								end;
								if VehicleInspector.simple.seeProzent and fillLevelVehicle.capacity > 0 then
									local prozent = VehicleInspector:get_hl("getProzentFillLevel", {fillLevelVehicle.fillLevel, fillLevelVehicle.capacity, true}, "Vehicle ProzentFillLevel aNumber"); 
									if prozent ~= nil and tonumber(prozent) >= 100 then foundFillFull = true;end;
									if not VehicleInspector.simple.seeFillLevel then 
										outputString[#outputString].txt = tostring(prozent).. "%";										
										if (attachedSprayerAnd <= 1 and attach == 1) or (attachedSprayerAnd == attach) then --Unknown Seeds or Fill etc.
											local color, isOkay = VehicleInspector:get_hl("getProzentColor", {prozent, invertProzent}, "Vehicle FillLevel/Capacity Prozent Color"); 											
											if not isOkay then color = 1;end;
											outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[color];												
											if isOkay and color == 7 and not VehicleInspector.simple.seeFillLevel then
												table.insert(outputString, 1, {});
												foundFirstFillOrTxt = true;
												outputString[1].txt = otherFull;
												if invertProzent then outputString[1].txt = otherSaEmpty;end;
												outputString[1].txtColor = VehicleInspector.simple.color.prozent[color]; --Full oder Empty
												outputString[1].txtBold = true;
											end;										
										end;
									else
										outputString[#outputString].txt = outputString[#outputString].txt.. " (".. tostring(prozent).. "%)";
									end;
								end;
								if VehicleInspector.simple.seeFillName then
									local newString = outputString[#outputString].txt;										
									local fillTypeName = FillTypeManager.getFillTypeNameByIndex(g_fillTypeManager, fillLevelVehicle.fillType);
									if not VehicleInspector.simple.seeRealFillName then local fillTypeNameTemp = g_fillTypeManager.nameToFillType[fillTypeName].title;fillTypeName = fillTypeNameTemp;end;
									local fillNameSub = ".."
									if string.len(fillTypeName) <= VehicleInspector.simple.maxFillNameLength then fillNameSub = "";end;
									fillTypeName = string.sub(fillTypeName, 0, VehicleInspector.simple.maxFillNameLength);
									outputString[#outputString].txt = tostring(fillTypeName).. fillNameSub.. fillNameToFillLevel.. newString;
								end;
								if invertProzent or attachedSprayerAnd > 0 then								
									local newString = outputString[#outputString].txt
									if (attachedSprayerAnd <= 1 and attach == 1) or (attachedSprayerAnd == attach) then
										outputString[#outputString].txt = otherSa.. newString;										
									else
										outputString[#outputString].txt = otherSaOrFill.. newString;
									end;
								end;									
							end;
						end;						
					end;
					return foundFillLevel, foundFillFull;
				end;
				--separate function check FillLevel for isFillFull and seeAll
											
								
				if seeLine or seeLineFillLevelOrFull or seeLineParkingVehicle then					
					-----with horse see always Name
					if VehicleInspector.simple.seeVehicleName or VehicleInspector.simple.seeVehicleSmallName or VehicleInspector.simple.seeVehicleTypeName then
						outputString[#outputString+1] = {};
						VehicleInspector:setVehicleName(self, vehicle, false);					
						local vehicleName = tostring(vehicle.viVehicleName);
						if VehicleInspector.simple.seeVehicleSmallName then vehicleName = tostring(vehicle.getName(vehicle));end;
						if VehicleInspector.simple.seeVehicleTypeName then vehicleName = tostring(vehicle.typeDesc);end;
						local vehicleNameSub = ".."
						if string.len(vehicleName) <= VehicleInspector.simple.maxVehicleNameLength then vehicleNameSub = "";end;
						vehicleName = string.sub(vehicleName, 0, VehicleInspector.simple.maxVehicleNameLength);						
						outputString[#outputString].txt = tostring(vehicleName).. vehicleNameSub;						
						--repair/damage !!! not found, later search new (search getWearTotalAmount())getWorkWearMultiplier, spec_wearable.totalAmount,getWearMultiplier
						--local damageLevel = g_i18n:formatNumber(100-Utils.getNoNil(vehicle.getVehicleDamage(vehicle), 0)*100); --later Update and Color
						--local color, isOkay = VehicleInspector:get_hl("getProzentColor", {damageLevel, true}, "Vehicle DamageLevel Color"); 
						--if not isOkay then color = 1;end;
						--outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[color];
						--if color == 7 then outputString[#outputString].txtBold = true;end;
						--outputString[#outputString].txt = outputString[#outputString].txt.. "/".. tostring(damageLevel).. "%";
					end;					
					if foundHorse and Horse ~= nil then
						foundFirstFillOrTxt = true;
						outputString[#outputString].txt = VehicleInspector.simple.txt.horse.. tostring(vehicle.getName(vehicle));
						if VehicleInspector.simple.seeHorseFitness then
							local fitnessScale = g_i18n:formatNumber(Utils.getNoNil(Horse.getFitnessScale(vehicle.spec_rideable.animal), 0)*100);
							outputString[#outputString+1] = {};
							outputString[#outputString].txt = horseFitnessTxt.. tostring(fitnessScale).. "%";
							if VehicleInspector.simple.horseWarningColor then
								local color, isOkay = VehicleInspector:get_hl("getProzentColor", {fitnessScale, true}, "Horse Fitness Color"); 
								if not isOkay then color = 2;end;
								if color == 1 then color = 2;end;
								outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[color];
								if color == 7 then outputString[#outputString].txtBold = true;end;
							end;
						end;
						if VehicleInspector.simple.seeHorseHealth then
							local healthScale = g_i18n:formatNumber(Utils.getNoNil(Horse.getHealthScale(vehicle.spec_rideable.animal), 0)*100);
							outputString[#outputString+1] = {};
							outputString[#outputString].txt = horseHealthTxt.. tostring(healthScale).. "%";
							if VehicleInspector.simple.horseWarningColor then
								local color, isOkay = VehicleInspector:get_hl("getProzentColor", {healthScale, true}, "Horse Health Color"); 
								if not isOkay then color = 2;end;
								if color == 1 then color = 2;end;
								outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[color];
								if color == 7 then outputString[#outputString].txtBold = true;end;
							end;
						end;
						if VehicleInspector.simple.seeHorseCare then							
							local careScale = g_i18n:formatNumber(100-(Utils.getNoNil(Horse.getDirtScale(vehicle.spec_rideable.animal), 0)*100)); --check sauberkeit						
							outputString[#outputString+1] = {};
							outputString[#outputString].txt = horseCareTxt.. tostring(careScale).. "%";
							if VehicleInspector.simple.horseWarningColor then
								local color, isOkay = VehicleInspector:get_hl("getProzentColor", {careScale, true}, "Horse Care Color"); 
								if not isOkay or color == 1 then color = 2;end;
								outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[color];
								if color == 7 then outputString[#outputString].txtBold = true;end;
							end;
						end;						
						if VehicleInspector.simple.seeHorseDayRiding then							
							local dayRidingTime = g_i18n:formatNumber(Utils.getNoNil(vehicle.spec_rideable.animal.ridingScale, 0)*100);
							outputString[#outputString+1] = {};
							outputString[#outputString].txt = horseDayRidingTxt.. tostring(dayRidingTime).. "%"; --/ ".. tostring(dayRidingTimer);
							if VehicleInspector.simple.horseWarningColor then
								local color, isOkay = VehicleInspector:get_hl("getProzentColor", {dayRidingTime, true}, "Horse DayRidingTime Color");
								if not isOkay or color == 1 then color = 2;end;
								outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[color];
								if color == 7 then outputString[#outputString].txtBold = true;end;
							end;
						end;
						if VehicleInspector.simple.seeHorseTodayRiding then
							local todaysRidingTimeTemp = Utils.getNoNil(Horse.getTodaysRidingTime(vehicle.spec_rideable.animal), 0);
							local todaysRidingTime = VehicleInspector:getMilliSecondsToHours(todaysRidingTimeTemp, VehicleInspector.simple.seeHorseTodayRidingMin, VehicleInspector.simple.seeHorseTodayRidingSec, horseTodayRidingHourTxt);
							outputString[#outputString+1] = {};
							outputString[#outputString].txt = horseTodayRidingTxt.. tostring(todaysRidingTime);
						end;
						
						--sellPrice unknown later new search (check ...getValueScale()*multiplier*???
						--local todaysRidingTimeTemp = Horse.getTodaysRidingTime(vehicle.spec_rideable.animal)
						--local todaysRidingTime = VehicleInspector:getMilliSecondsToHours(todaysRidingTimeTemp, true, true);
						--local todaysRidingTime = g_i18n:formatMinutes(todaysRidingTimeTemp)
						--local fitnessScale = string.format("%1.0f", "".. Utils.getNoNil(Horse.getFitnessScale(vehicle.spec_rideable.animal)*100, 0)).. "%"; --Horse.getFitnessScale(vehicle.spec_rideable.animal)*100
						--local healthScale = string.format("%1.1f", "".. Utils.getNoNil(Horse.getHealthScale(vehicle.spec_rideable.animal)*100, 0)).. "%";
						--local healthScale = g_i18n:formatNumber(Utils.getNoNil(Horse.getHealthScale(vehicle.spec_rideable.animal)*100, 0));
						
						--string.format("%1.0f", "".. Utils.getNoNil(Horse.getHealthScale(vehicle.spec_rideable.animal)*100, 0));
						--oder getValueScale() testen
						--local sellPrice = g_i18n:formatMoney(vehicle.getSellPrice(vehicle)) --gibt 7 statt 2.975						
						--local sellPrice = vehicle.getSellPrice(vehicle) --gibt 7 statt 2.975
						--local sellPriceTemp = Horse.getValueScale(vehicle.spec_rideable.animal)
						--local difficultyMultiplier = EconomyManager.getPriceMultiplier() --math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1)
						--local sellPrice = g_i18n:formatMoney(vehicle.getSellPrice(vehicle)*sellPriceTemp*difficultyMultiplier*100);
						--renderText(0.5, 0.24, 0.010, "Total geritten_ ".. tostring(todaysRidingTime).. "   Fitness_ ".. tostring(fitnessScale));
						--renderText(0.5, 0.22, 0.010, "Health_ ".. tostring(healthScale).. "   SellPrice_ ".. tostring(sellPrice));
						--renderText(0.5, 0.21, 0.010, "Multiplier_ ".. tostring(difficultyMultiplier));
						--sellPrice unknown later new search
					end;
					-----with horse always Name
					if VehicleInspector.simple.isLeasing and not VehicleInspector.simple.leasingTxtLast and vehicle.propertyState == 2 and string.len(otherL) > 0 then --first Leasing
						table.insert(outputString, 1, {});											
						outputString[1].txt = tostring(otherL);
						outputString[1].txtColor = VehicleInspector.simple.color.isLeasing;
					end;
					
					if VehicleInspector.simple.seeField and vehicle.trainSystem == nil then
						local fieldNumber, isField = VehicleInspector:getIsOnField(vehicle);						
						table.insert(outputString, 1, {});
						if isField then							
							outputString[1].txtBold = true;
							outputString[1].txtColor = VehicleInspector.simple.color.isField;
							if not VehicleInspector.simple.seeFieldNumber then fieldNumber = "";end;
						else fieldNumber = "";
						end;
						outputString[1].txt = tostring(VehicleInspector.simple.txt.field).. tostring(fieldNumber);						
					end;
					if VehicleInspector.simple.seeSpeed then
						table.insert(outputString, 1, {});						
						outputString[1].txt = VehicleInspector:getSpeed(vehicle).. tostring(VehicleInspector.simple.txt.speed);
					end;					
					if vehicle.trainSystem == nil and VehicleInspector.simple.isWater and vehicle.showTailwaterDepthWarning then
						table.insert(outputString, 1, {});
						outputString[1].txt = otherW;
						outputString[1].txtColor = VehicleInspector.simple.color.isWater;
						outputString[1].txtBold = true;
					end;
					if vehicle.trainSystem == nil and VehicleInspector.simple.isDamage and vehicle.isBroken then
						table.insert(outputString, 1, {});
						outputString[1].txt = otherD;
						outputString[1].txtColor = VehicleInspector.simple.color.isDamage;
						outputString[1].txtBold = true;
					end;
					
					if not foundHorse then
						--new 1.46
						local foundFillLevel, foundFillFull = getFillLevel();
						---new see all---				
						if (not seeLine and seeLineFillLevelOrFull) then
							if (VehicleInspector.simple.isFillFull and foundFillFull) or (VehicleInspector.simple.isFillLevel and foundFillLevel) then seeLine = true;end;
							if vehicle.trainSystem ~= nil and not VehicleInspector.simple.isTrain then seeLine = false;end;
							if vehicle.trainSystem == nil and (not isOwnFarmVehicle and VehicleInspector.simple.ownFarmVehicle) then seeLine = false;end;
						end;
						---new see all---
						--new 1.46						
					end;
					
					--MP check Server and send event for Blocking etc. !!					
					if not foundFirstFillOrTxt and VehicleInspector.simple.isBlocking and not vehicle.showTailwaterDepthWarning and vehicle.spec_aiVehicle ~= nil then
						local blockingMP = VehicleInspector:getCollisionMP(vehicle); --check for MP Blocking
						if blockingMP or (vehicle.spec_aiVehicle.debugTexts ~= nil and vehicle.spec_aiVehicle.debugTexts[1] ~= nil and string.find(vehicle.spec_aiVehicle.debugTexts[1], "STOP") and string.find(vehicle.spec_aiVehicle.debugTexts[1], "collision")) then		
							table.insert(outputString, 1, {});
							outputString[1].txt = otherB;
							outputString[1].txtColor = VehicleInspector.simple.color.isBlocking;
							outputString[1].txtBold = true;	
						end;												
					end;					
					--MP check Server and send event for Blocking etc. !!
					
					if VehicleInspector.simple.isLeasing and VehicleInspector.simple.leasingTxtLast and vehicle.propertyState == 2 and string.len(otherL) > 0 then --last Leasing
						outputString[#outputString+1] = {};											
						outputString[#outputString].txt = tostring(otherL);
						outputString[#outputString].txtColor = VehicleInspector.simple.color.isLeasing;
					end;
					if attach > 0 and VehicleInspector.simple.seeLastTotalAttached then
						outputString[#outputString+1] = {};											
						outputString[#outputString].txt = tonumber(attach);					
					end;
					--ParkVehicle Mod
					if not foundHorse and VehicleInspector.simple.parkingVehicleModSupport and VehicleInspector.simple.seeParkingVehicleMarker and vehicle.spec_parkvehicle ~= nil then
						local spec = vehicle.spec_parkvehicle;
						if spec.state[spec.uniqueUserId] then
							outputString[#outputString+1] = {};											
							outputString[#outputString].txt = "P";
							outputString[#outputString].txtColor = VehicleInspector.simple.color.prozent[4];
							outputString[#outputString].txtBold = true;
						end;
					end;
					--ParkVehicle Mod
				end;
				local newHeight = true;
				local foundHelper = false;
				if (seeLine and VehicleInspector.simple.isDraw.modus == 0) or (not seeLine and VehicleInspector.simple.isDraw.modus == 1) then
					for b=1, #outputString do						
						if outputString[b] ~= nil and string.len(outputString[b].txt) > 0 then
							local tableValue = #drawSeeLineOutputString;							
							drawSeeLineOutputString[tableValue].outputString[b] = {};							
							if outputString[b].isPlayer ~= nil then drawSeeLineOutputString[tableValue].isSort = true;end;
							if VehicleInspector.simple.seeHelperFirst and outputString[b].isHelper ~= nil then foundHelper = true;end;
							--txtHeight not relevante later for mouse click areas
							if newHeight then txtHeight = txtHeight+getTextHeight(size, tostring(outputString[b].txt).. separator)+lineDistancePosY;newHeight = false;end;							
							drawSeeLineOutputString[tableValue].outputString[b].txtColor = Utils.getNoNil(outputString[b].txtColor, VehicleInspector.simple.color.default);
							drawSeeLineOutputString[tableValue].outputString[b].txtHeight = getTextHeight(size, tostring(outputString[b].txt).. separator)+lineDistancePosY;
							drawSeeLineOutputString[tableValue].outputString[b].txtBold = Utils.getNoNil(outputString[b].txtBold, VehicleInspector.simple.allTxtBold);
							drawSeeLineOutputString[tableValue].outputString[b].txt = tostring(outputString[b].txt);
							--setTextColor(unpack(VehicleInspector.simple.color.default));							
							--setTextBold(VehicleInspector.simple.allTxtBold);
							--if outputString[b].txtColor ~= nil then setTextColor(unpack(outputString[b].txtColor));end;
							--if outputString[b].txtBold ~= nil then setTextBold(outputString[b].txtBold);end;
							--renderText(posX+txtWidth, posY-txtHeight, size, tostring(outputString[b].txt));						
							drawSeeLineOutputString[tableValue].outputString[b].txtWidth = txtWidth;
							txtWidth = txtWidth+lineNextTxtDistancePosX+getTextWidth(size, tostring(outputString[b].txt));							
							--separator
							--setTextColor(unpack(VehicleInspector.simple.color.default));							
							--setTextBold(VehicleInspector.simple.allTxtBold);
							--renderText(posX+txtWidth, posY-txtHeight, size, separator);
							drawSeeLineOutputString[tableValue].outputString[b].txtWidthSeparator = txtWidth;
							txtWidth = txtWidth+lineNextTxtDistancePosX+getTextWidth(size, separator);
							if txtWidthDraw < txtWidth then txtWidthDraw = txtWidth;end; --for background
							--separator
						end;
					end;					
					if foundHelper and #drawSeeLineOutputString > 1 then table.insert(drawSeeLineOutputString, 1, drawSeeLineOutputString[#drawSeeLineOutputString]);table.remove(drawSeeLineOutputString, #drawSeeLineOutputString)end;
				
				else
					table.remove(drawSeeLineOutputString, #drawSeeLineOutputString); --here seeAllVehicle later(seeLine/seeLineFillLevelOrFull ignore then)
					
				end;
			end;
		end;		
		function sortByPlayer(w1,w2)			
			return w1.isSort and not w2.isSort;					
		end;
		local txtHeightDraw = 0;
		local txtHeightMax = 0;
		VehicleInspector.simple.isDraw[2] = Utils.getNoNil(#drawSeeLineOutputString, 0); --check for Keyboard input		
		if VehicleInspector.simple.isSelectVehicle and VehicleInspector.simple.selectVehicle > VehicleInspector.simple.isDraw[2] then VehicleInspector.simple.selectVehicle = VehicleInspector.simple.isDraw[2];end;
		if #drawSeeLineOutputString > 0 then			
			if VehicleInspector.simple.color.seeBackground then VehicleInspector.overlays["ground"]:render();end;
			if VehicleInspector.simple.seePlayerFirst then table.sort(drawSeeLineOutputString, sortByPlayer);end;			
			for a=1, #drawSeeLineOutputString do
				local newHeightDraw = true;
				if drawSeeLineOutputString[a] ~= nil and drawSeeLineOutputString[a].outputString ~= nil and #drawSeeLineOutputString[a].outputString > 0 then
					for b=1, #drawSeeLineOutputString[a].outputString do
						if drawSeeLineOutputString[a].outputString[b] ~= nil then
							local outputString = drawSeeLineOutputString[a].outputString[b];
							local firstHeightDownPos = a==1 and VehicleInspector.simple.showMod.posDown;
							if not firstHeightDownPos and newHeightDraw then txtHeightDraw = txtHeightDraw+getTextHeight(size, tostring(outputString.txt).. separator)+lineDistancePosY;newHeightDraw = false;end;
							setTextColor(unpack(outputString.txtColor));							
							setTextBold(outputString.txtBold);
							if VehicleInspector.simple.showMod.posDown then
								renderText(posX+outputString.txtWidth, posY+txtHeightDraw, size, tostring(outputString.txt));
							else
								renderText(posX+outputString.txtWidth, posY-txtHeightDraw, size, tostring(outputString.txt));
							end;
							--separator
							setTextColor(unpack(VehicleInspector.simple.color.default));							
							setTextBold(VehicleInspector.simple.allTxtBold);
							if VehicleInspector.simple.showMod.posDown then
								renderText(posX+outputString.txtWidthSeparator, posY+txtHeightDraw, size, separator);
							else
								renderText(posX+outputString.txtWidthSeparator, posY-txtHeightDraw, size, separator);
							end;
							if txtHeightMax <= 0 then txtHeightMax = txtHeightDraw;end;
							--separator
							--selectVehicle
							if VehicleInspector.simple.isSelectVehicle and VehicleInspector.simple.selectVehicle == a then								
								VehicleInspector.simple.isDraw[3] = Utils.getNoNil(drawSeeLineOutputString[a].vehicleNumber, 0);
								VehicleInspector.simple.isDraw[4] = Utils.getNoNil(drawSeeLineOutputString[a].vehicleNode, 0);
								local balance = 0.003;								
								if VehicleInspector.simple.showMod.posDown then
									VehicleInspector:setOverlay(VehicleInspector.overlays["selectVehicle"], posX-balance, posY+txtHeightDraw-(lineDistancePosY/2), 0.002, outputString.txtHeight); --balance = posY 0.001(balance) see Draw setBackground posY is posDown=true(VehicleInspector:setCheckInGameMapPosX_Y)
								else
									VehicleInspector:setOverlay(VehicleInspector.overlays["selectVehicle"], posX-balance, posY-txtHeightDraw-(lineDistancePosY/2), 0.002, outputString.txtHeight);
								end;
								if g_currentMission.player.farmId ~= Utils.getNoNil(drawSeeLineOutputString[a].vehicleFarm, 0) then
									VehicleInspector:setBackgroundColor(VehicleInspector.overlays["selectVehicle"], VehicleInspector.simple.color.isSelectVehicleNotFarm);
								else
									VehicleInspector:setBackgroundColor(VehicleInspector.overlays["selectVehicle"], VehicleInspector.simple.color.isSelectVehicle);
								end;
								VehicleInspector.overlays["selectVehicle"]:render();
							end;
						end;
					end;
				end;
			end;
			if VehicleInspector.simple.color.seeBackground then
				if VehicleInspector.simple.showMod.posDown then 
					VehicleInspector:setOverlay(VehicleInspector.overlays["ground"], posX-0.001, posY-0.001, txtWidthDraw+0.002, txtHeightDraw+0.002+txtHeightMax);
				else
					VehicleInspector:setOverlay(VehicleInspector.overlays["ground"], posX-0.001, posY-txtHeightDraw-0.001, txtWidthDraw+0.002, txtHeightDraw+0.002);		
				end; --posY 0.001(balance) see Draw setBackground posY is posDown=true(VehicleInspector:setCheckInGameMapPosX_Y)
			end;
		else
			VehicleInspector.simple.isDraw[1] = false;VehicleInspector.simple.isDraw[3] = 0;
		end;		
	end;	
	--respect settings for other mods
	setTextAlignment(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods	
end;

function VehicleInspector:get_hl(args, argsTable, errorTxtCall) --args hl table, argsTable a table with all args Values, errorTxt a Value for debug print
	local isOkay, result, argsError, errorTxt = nil,nil,nil,errorTxtCall;
	if VehicleInspector.hlDebugMode and (errorTxtCall == nil or type(errorTxtCall) ~= "string" or string.len(errorTxtCall) == 0) then errorTxt = "Unknown";end;
	local foundArgsError = false;
	if type(argsTable) == "table" and g_currentMission.hl[args] ~= nil then	
		isOkay, result = pcall(g_currentMission.hl[args], unpack(argsTable));
	else
		foundArgsError = true;
	end;
	if VehicleInspector.hlDebugMode and foundArgsError then isOkay=false;argsError="Unknown args or argsTable or argsTable = 0";end;		
	if VehicleInspector.hlDebugMode and (not isOkay or foundArgsError) then VehicleInspector:setDebug("VehicleInspectorMod", args or "Unknown", errorTxt, argsError or "No args error", result or "NO result error");end;
	return result, isOkay;	
end;

function VehicleInspector:setDebug(argsMod, args1, errorTxt, args2, args3)	
	if g_currentMission.hl.debug == nil then g_currentMission.hl.debug = {};end;
	if g_currentMission.hl.debug[argsMod] == nil then g_currentMission.hl.debug[argsMod] = {};end;
	local errorString = "Trigger: ".. tostring(args1).. " -errorTxtCall: ".. tostring(errorTxt).. " -argsError: ".. tostring(args2).. " -resultError: ".. tostring(args3);
	local alreadyExists = false;
	if #g_currentMission.hl.debug[argsMod] == 0 then table.insert(g_currentMission.hl.debug[argsMod], tostring(errorString));else
		for key,value in pairs(g_currentMission.hl.debug[argsMod]) do			
			if tostring(value) == errorString and string.len(value) == string.len(errorString) then alreadyExists=true;break;end;			
		end;		
		if not alreadyExists then table.insert(g_currentMission.hl.debug[argsMod], tostring(errorString));end;
	end;	
end;

function VehicleInspector:isInvertFill(typeName)
	for key,value in pairs(VehicleInspector.simple.searchInvert) do
		if string.find(VehicleInspector.simple.searchInvert[key], typeName) and string.len(typeName) == string.len(VehicleInspector.simple.searchInvert[key]) then return true;end;		
	end;
	return false;
end;

function VehicleInspector:getSpeed(vehicle)
	local speed = Utils.getNoNil(vehicle.lastSpeed, 0)*3600;
	if g_gameSettings:getValue('useMiles') then speed = speed*0.621371;end;
	--if vehicle.viVehicleName == "Train" or vehicle.trainSystem ~= nil then speed = speed*3.6;end;
	return string.format("%1.0f", "".. Utils.getNoNil(speed, 0));
end;

--function VehicleInspector:getIsOnField(vehicle)
--    local wx,wy,wz = getWorldTranslation(vehicle.components[1].node);
--    local densityBits = getDensityAtWorldPos(g_currentMission.terrainDetailId, wx, wy, wz);
 --   return densityBits, densityBits ~= 0;
--end;

function VehicleInspector:getAttachedAndSprayerAnd(vehicle, attachedLimit)	
	local attached = 0;
	local attachedSprayerAnd = 0;
	if vehicle.getAttachedImplements ~= nil then 
		local attachTable = vehicle.getAttachedImplements(vehicle);
		if attachTable ~= nil and attachedLimit <= VehicleInspector.simple.attachedLimit then		
			for _,attach in pairs(attachTable) do		
				if attach.object ~= nil and attach.object.typeName ~= nil then
					local typeName = Utils.getNoNil(string.lower(attach.object.typeName), "Unknown");
					if not string.find(typeName, "implements") and not string.find(typeName, "Unknown") then
						attached = attached+1;
					end;					
					if VehicleInspector:isInvertFill(typeName) then 
						attachedSprayerAnd = attachedSprayerAnd+1;
					end;
					local tempAttached, tempAttachedSprayerAnd = VehicleInspector:getAttachedAndSprayerAnd(attach.object, attachedLimit+1);
					attached = attached+tempAttached;
					attachedSprayerAnd = attachedSprayerAnd+tempAttachedSprayerAnd;
				end;
			end;
		end;
	end;
	return attached, attachedSprayerAnd;
end;

function VehicleInspector:getCollisionMP(vehicle)	
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return false;end;
	if vehicle.spec_aiVehicle.isActive then
		if vehicle:getLastSpeed() < 0.5 then 
			vehicle.spec_aiVehicle.didNotMoveTimer = vehicle.spec_aiVehicle.didNotMoveTimer-10;
		else
			vehicle.spec_aiVehicle.didNotMoveTimer = vehicle.spec_aiVehicle.didNotMoveTimeout;
		end;
		if vehicle.spec_aiVehicle.didNotMoveTimer < 0 then return true;end;
	else
		vehicle.spec_aiVehicle.didNotMoveTimer = vehicle.spec_aiVehicle.didNotMoveTimeout;
	end;
	return false;
end;
	
function VehicleInspector:getIsOnField(vehicle)
    local fieldNumber = 0;
	local isField = false;
	local wx, wy, wz = 0,0,0;
	function getIsOnField()
		local densityBits = 0;
		for _,component in pairs(vehicle.components) do
			wx, wy, wz = getWorldTranslation(component.node);
			local h = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, wx, wy, wz);
			if h-1 > wy then 
				break;
			end
			local bits = getDensityAtWorldPos(g_currentMission.terrainDetailId, wx, wy, wz);
			densityBits = bitOR(densityBits, bits);
			if densityBits ~= 0 then
				isField = true;
				return true;
			end
		end
		return false;
	end
	if getIsOnField() and VehicleInspector.simple.seeFieldNumber then		
		local foundField = false;
		for fieldNum,fieldDef in ipairs(g_fieldManager.fields) do		
			if foundField then break;end;
			for a=1, #fieldDef.setFieldStatusPartitions do
				local b = fieldDef.setFieldStatusPartitions[a];
				local x, z, wX, wZ, hX, hZ = b.x0, b.z0, b.widthX, b.widthZ, b.heightX, b.heightZ;
				local distanceMax = math.max(wX,wZ,hX,hZ);
				local distance = MathUtil.vector2Length(wx-x,wz-z);
				local fruitDesc = g_currentMission.fruitTypeManager.fruitTypes[fieldDef.fruitType];				
				--renderText(0.5, 0.96, 0.010, "fruitDesc_ ".. tostring(fruitDesc.name));
				local noFruit = fruitDesc ~= nil and fruitDesc.name == "UNKNOWN" --or fruitDesc.name == "GRASS" or fruitDesc.name == "DRYGRASS" or fruitDesc.name == "WEED"
				if not noFruit and distance <= distanceMax then 
					fieldNumber = fieldDef.fieldId;foundField=true;
					--print("distance...".. tostring(distance).. " - maxDistance...".. tostring(distanceMax))
					break;
				end;				
			end;			
		end;
	end;
	return fieldNumber, isField;	
end;

--VI LS17 Script, later new
function VehicleInspector:setVehicleName(self, vehicle, attachable)
	local vehicleName = "Unknown";
	local category = "Unknown";
	function setAlternativeName()
		if vehicle.baleWidth ~= nil then
			vehicle.viVehicleName = "Bale";
			vehicleName = "Bale";
		elseif vehicle.fillablePalletDirtyFlag ~= nil then
			vehicle.viVehicleName = "Pal.";
			vehicleName = "Pal.";
		end;
	end;
	--vehicle.getFullName(vehicle) okay return New Holland Tx 32
	--vehicle.getName(vehicle) okay return Tx32
	--!! not all vehicle.fullViewName = Combine
	--controlGroupNames --a table
	--vehicle.getControllerName(vehicle) okay return your User name
	--className = Vehicle
	--name = combineDrivable
	--nicknameRendering --a table
	--vehicle.typeName = 
	--vehicle.typeDesc = 
	
	--g_currentMission.vehicles.getIsVehicleControlledByPlayer()
	--getIsControlled()
	--getControllerName()
	--getFillUnitFillLevelPercentage()
	--getFillLevelInformation()
	
	if vehicle.configFileName == nil then 
		setAlternativeName();
		vehicle.viVehicleName = vehicleName;
		return;
	end;
	if vehicle.viVehicleName ~= nil then return;end;
	--local storeItem = StoreItemsUtil.storeItemsByXMLFilename[Utils.getNoNil(vehicle.configFileName, vehicle.xmlFilename):lower()];
    --if storeItem ~= nil then
    --    if storeItem.name ~= nil then
    --        vehicleName = tostring(storeItem.name);
    --    end;
        --if storeItem.category ~= nil and storeItem.category ~= "" then
        --    category = tostring(storeItem.category);
        --end;	
	--end;		
	
	vehicleName = tostring(vehicle.getFullName(vehicle));
	
	--local vehicleXml = loadXMLFile("MultiOverlayV2_XML", vehicle.configFileName, "vehicle");
	if vehicle.configFileName ~= nil then
		if string.find(tostring(vehicle.configFileName), "locomotive") then
			vehicleName = "Train";		
			if not attachable then vehicle.typeDesc = vehicleName;end;
		elseif string.find(tostring(vehicle.configFileName), "horse") then
			vehicleName = "Horse";
		elseif string.find(tostring(vehicle.configFileName), "stationCrane") then
			vehicleName = "Crane";
			if not attachable then vehicle.typeDesc = vehicleName;end;
		elseif string.find(tostring(vehicle.configFileName), "wagon") then
			vehicleName = "WagonFill";
			if string.find(tostring(vehicle.configFileName:lower()), "timber") then
				vehicleName = "WagonTimber";
			end;
			if attachable then vehicle.typeDesc = vehicleName;end;
		elseif string.find(tostring(vehicle.configFileName), "ka26") then
			vehicleName = "Heli";
			if not attachable then vehicle.typeDesc = vehicleName;end;
		elseif vehicle.time ~= nil and vehicle.time > 0 then
			vehicleName = vehicleName.. "-Missions Vehicle";
		end;
	end;
	if vehicleName == "Unknown" then setAlternativeName();end;
	--tableVehicle.name = vehicleName;	
	vehicle.viVehicleName = vehicleName;
end;

function VehicleInspector:init()
	source(VehicleInspector.modDir.."_hl.lua");
end;

function VehicleInspector:getMilliSecondsToHours(sMilliSeconds, getHoursMin, getHoursSec, endString)
	local nMilliSeconds = tonumber(sMilliSeconds);
	if nMilliSeconds == nil or nMilliSeconds == 0 then	
		return "0";
	else
		local nHours = string.format("%02.f", math.floor(nMilliSeconds/3600000));
		local nMins = string.format("%02.f", math.floor(nMilliSeconds/60000 - (nHours*60)));	
		local nSecs = string.format("%02.f", math.floor((nMilliSeconds/1000 - nHours*3600 - nMins*60)));
		if not getHoursMin then return nHours.. tostring(endString);end;				
		if getHoursMin and getHoursSec == nil then return nHours..":"..nMins;end;
		if getHoursMin and getHoursSec then return nHours..":"..nMins..":"..nSecs;end;
	end;
	return "0";
end;

--check later is better !! g_currentMission.hud.inputHelp:getVisible()
function VehicleInspector:getInGameDisplay()
	local foundHelp = false;
	local foundMap = false;
	if g_currentMission.hud.ingameMap.state ~= nil then
		VehicleInspector.inGameMapMenu = g_currentMission.hud.ingameMap;foundMap=true;		
	end;
	if g_currentMission.hud.inputHelp.controlsLabelText ~= nil and g_currentMission.hud.inputHelp.numUsedEntries ~= nil then
		VehicleInspector.helpMenu = g_currentMission.hud.inputHelp;foundHelp=true;		
	end;
	if foundHelp and foundMap then return;end;
	for key, value in pairs(g_currentMission.hud.displayComponents) do
		if not foundHelp and g_currentMission.hud.displayComponents[key].controlsLabelText ~= nil and g_currentMission.hud.displayComponents[key].numUsedEntries ~= nil then
			VehicleInspector.helpMenu = g_currentMission.hud.displayComponents[key];
			foundHelp = true;
		end;
		if not foundMap and g_currentMission.hud.displayComponents[key].state ~= nil then
			VehicleInspector.inGameMapMenu = g_currentMission.hud.displayComponents[key];
			foundMap = true;
		end;
		if foundMap and foundHelp then break;end;
	end;
end;

function VehicleInspector:loadOverlays()
	VehicleInspector.overlays["ground"] = Overlay:new("dataS2/menu/hud/hud_elements_2160p.png", 0, 0, 0, 0);
	setOverlayUVs(VehicleInspector.overlays["ground"].overlayId, 0.0078125,0.990234375, 0.0078125,0.9921875, 0.009765625,0.990234375, 0.009765625,0.9921875);
	VehicleInspector:setBackgroundColor(VehicleInspector.overlays["ground"], VehicleInspector.simple.color.isBackground);
	VehicleInspector.overlays["selectVehicle"] = Overlay:new("dataS2/menu/hud/hud_elements_2160p.png", 0, 0, 0, 0);
	setOverlayUVs(VehicleInspector.overlays["selectVehicle"].overlayId, 0.0078125,0.990234375, 0.0078125,0.9921875, 0.009765625,0.990234375, 0.009765625,0.9921875);
	VehicleInspector:setBackgroundColor(VehicleInspector.overlays["selectVehicle"], VehicleInspector.simple.color.isSelectVehicle);
end;

function VehicleInspector:setBackgroundColor(overlay, color)
	if overlay.overlayId then		
		setOverlayColor(overlay.overlayId, unpack(color));		
	end;
end;

function VehicleInspector:setOverlay(overlay, posX, posY, width, height)
	if overlay.overlayId then
		if width ~= nil then overlay.width = width;end;
		if height ~= nil then overlay.height = height;end;
		if posX ~= nil then overlay.x = posX;end;
		if posY ~= nil then overlay.y = posY;end;		
	end;
end;

function VehicleInspector:deleteOverlays()
	if VehicleInspector.overlays ~= nil then		
		for _index,v in pairs (VehicleInspector.overlays) do
			local overlay = VehicleInspector.overlays[_index];
			if overlay ~= nil and overlay and overlay.overlayId ~= nil and overlay.overlayId then
				overlay:delete();
				overlay = nil;
			end;
		end;
	end;
end;

function VehicleInspector:setGetCfg(loadCfg)
	createFolder(getUserProfileAppPath().. "modsSettings/");
	createFolder(VehicleInspector.settingsDir);
	local file = VehicleInspector.settingsDir.. "vehicleInspectorSettings.xml";
	local Xml = nil;
	local xmlVersion = 0.2;
	if not fileExists(file) or not loadCfg then		
		Xml = createXMLFile("VehicleInspector_XML", file, "vehicleInspectorSettings");
		local groupNameTag = ("vehicleInspectorSettings.simple.version(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#xmlVersion", tostring(xmlVersion));
		
		--TEST MODUS
		local groupNameTag = ("vehicleInspectorSettings.simple.NO_SUPPORT_TEST.isTest(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isSelectVehicle);
		groupNameTag = ("vehicleInspectorSettings.simple.NO_SUPPORT_TEST.attention(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#info", "PRESSED LSHIFT+KEY UP/DOWN (Select Vehicle) -- PRESSED LSHIFT+KEY ENTER (JOIN Vehicle) -- PRESSED LSHIFT+KEY RIGHT (VI Modus)");
		groupNameTag = ("vehicleInspectorSettings.simple.NO_SUPPORT_TEST.attention(%d)"):format(1);
		setXMLString(Xml, groupNameTag.. "#info", "suggestions and error messages YES");		
		--TEST MODUS
		
		local groupNameTag = ("vehicleInspectorSettings.simple.global(%d)"):format(0);		
		setXMLBool(Xml, groupNameTag.. "#isOn", VehicleInspector.simple.isOn);
		setXMLFloat(Xml, groupNameTag.. "#posX", VehicleInspector.simple.defaultPosX);
		setXMLFloat(Xml, groupNameTag.. "#posY", VehicleInspector.simple.defaultPosY);		
		setXMLFloat(Xml, groupNameTag.. "#downPosX", VehicleInspector.simple.defaultDownPosX);
		setXMLFloat(Xml, groupNameTag.. "#downPosY", VehicleInspector.simple.defaultDownPosY);
		setXMLBool(Xml, groupNameTag.. "#resetPosY", VehicleInspector.simple.resetPosY);
		setXMLBool(Xml, groupNameTag.. "#rebootXmlESC", VehicleInspector.simple.rebootXml);
		setXMLBool(Xml, groupNameTag.. "#hlDebugMode", VehicleInspector.hlDebugMode);
		
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.parkingVehicleSupport(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.parkingVehicleModSupport);
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.seeParkingVehicle(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeParkingVehicle);
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.seeParkingVehicleMarker(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeParkingVehicleMarker);
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.joinParkingVehicle(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.joinParkingVehicle);
		
		
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.posDown(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.showMod.posDown);
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOn_F1(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.showMod.helpMenuOn);
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOnAndInputEmpty(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.showMod.helpMenuOnAndInputEmpty);
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOff_F1(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.showMod.helpMenuOff);
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOffAndInputEmpty(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.showMod.helpMenuOffAndInputEmpty);
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isInGameMapOn(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.showMod.inGameMapOn);
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isInGameMapOff(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.showMod.inGameMapOff);
		
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.maxFillNameLength(%d)"):format(0);
		setXMLInt(Xml, groupNameTag.. "#int", VehicleInspector.simple.maxFillNameLength);
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.maxVehicleNameLength(%d)"):format(0);
		setXMLInt(Xml, groupNameTag.. "#int", VehicleInspector.simple.maxVehicleNameLength);
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.txtSize(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#float", VehicleInspector.simple.defaultSize);
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.txtAllBold(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.allTxtBold);
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.leasingTxtLast(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.leasingTxtLast);
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.attachedLimit(%d)"):format(0);
		setXMLInt(Xml, groupNameTag.. "#int", VehicleInspector.simple.attachedLimit);		
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.lineNextTxtDistancePosX(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#float", VehicleInspector.simple.lineNextTxtDistancePosX);
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.lineDistancePosY(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#float", VehicleInspector.simple.lineDistancePosY);
		local searchInvertTemp = ""
		for key,value in pairs(VehicleInspector.simple.searchInvert) do
			if string.len(searchInvertTemp) > 0 then searchInvertTemp = searchInvertTemp.. ",".. tostring(VehicleInspector.simple.searchInvert[key])
			else searchInvertTemp = searchInvertTemp.. tostring(VehicleInspector.simple.searchInvert[key]);end;
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.searchInvertColorByVehicleTypeName(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#stringWithCommaseparator", tostring(searchInvertTemp));
		
		
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isFillFull(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isFillFull);
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isTrain(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isTrain);
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isPlayer(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isPlayer);
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isHorsePlayer(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isHorsePlayer);
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isHelper(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isHelper);
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.ownFarmVehicle(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.ownFarmVehicle);
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isFillLevel(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isFillLevel);
		
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seePlayerFirst(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seePlayerFirst);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeHelperFirst(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHelperFirst);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeHelperName(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHelperName);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeField(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeField);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeFieldNumber(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeFieldNumber);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeSpeed(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeSpeed);		
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeFillName(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeFillName);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeRealFillName(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeRealFillName);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeFillLevel(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeFillLevel);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeProzent(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeProzent);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seePlayerName(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seePlayerName);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeVehicleName(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeVehicleName);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeVehicleSmallName(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeVehicleSmallName);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeVehicleTypeName(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeVehicleTypeName);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeLastTotalAttached(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeLastTotalAttached);
		
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isFuel(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isFuel);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isBlocking(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isBlocking);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isDamage(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isDamage);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isWater(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isWater);
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isLeasing(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.isLeasing);
						
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.defaultseparator(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.separator);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.fillNameToFillLevelseparator(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.fillNameToFillLevel);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSpeed(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.speed);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isField(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.field);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isHorse(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.horse);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isTrain(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherT);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isHelper(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.helperS);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isPlayer(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.playerS);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSeeds(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherSa);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSeedsEmpty(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherSaEmpty);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSeedsOrFill(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherSaOrFill);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isWater(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherW);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isDamage(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherD);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isBlocking(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherB);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isLeasing(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherL);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isFull(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherFull);
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isFuelEmty(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.otherFuelEmpty);
				
		groupNameTag = ("vehicleInspectorSettings.simple.horse.horseTxtWarningColor(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.horseWarningColor);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseHealth(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHorseHealth);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.healthTxt(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.horseHealth);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseFitness(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHorseFitness);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.fitnessTxt(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.horseFitness);		
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseCare(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHorseCare);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.careTxt(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.horseCare);		
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseTodayRiding(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHorseTodayRiding);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.todayRidingTxt(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.horseTodayRiding);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseTodayRidingMin(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHorseTodayRidingMin);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseTodayRidingSec(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHorseTodayRidingSec);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.todayRidingHourTxt(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.horseTodayRidingHour);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseDayRiding(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.seeHorseDayRiding);
		groupNameTag = ("vehicleInspectorSettings.simple.horse.dayRidingTxt(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#txt", VehicleInspector.simple.txt.horseDayRiding);
		
		groupNameTag = ("vehicleInspectorSettings.simple.colors.seeBackground(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.color.seeBackground);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isBackground(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.isBackground[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.isBackground[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.isBackground[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.isBackground[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.defaultTxt(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.default[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.default[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.default[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.default[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_0-24Fill(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.prozent[1][1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.prozent[1][2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.prozent[1][3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.prozent[1][4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_76-100Seeds(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.prozent[2][1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.prozent[2][2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.prozent[2][3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.prozent[2][4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_25-49(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.prozent[3][1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.prozent[3][2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.prozent[3][3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.prozent[3][4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_50-74(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.prozent[4][1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.prozent[4][2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.prozent[4][3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.prozent[4][4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_75-94(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.prozent[5][1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.prozent[5][2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.prozent[5][3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.prozent[5][4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_95-99(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.prozent[6][1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.prozent[6][2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.prozent[6][3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.prozent[6][4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_100(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.prozent[7][1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.prozent[7][2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.prozent[7][3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.prozent[7][4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.playerControlled(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.playerControlled[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.playerControlled[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.playerControlled[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.playerControlled[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.anotherPlayerControlled(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.anotherPlayerControlled[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.anotherPlayerControlled[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.anotherPlayerControlled[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.anotherPlayerControlled[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isFieldTxt(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.isField[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.isField[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.isField[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.isField[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isWaterTxt(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.isWater[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.isWater[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.isWater[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.isWater[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isDamageTxt(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.isDamage[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.isDamage[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.isDamage[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.isDamage[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isBlockingTxt(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.isBlocking[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.isBlocking[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.isBlocking[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.isBlocking[4]);
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isLeasingTxt(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#red", VehicleInspector.simple.color.isLeasing[1]);setXMLFloat(Xml, groupNameTag.. "#green", VehicleInspector.simple.color.isLeasing[2]);setXMLFloat(Xml, groupNameTag.. "#blue", VehicleInspector.simple.color.isLeasing[3]);setXMLFloat(Xml, groupNameTag.. "#alpha", VehicleInspector.simple.color.isLeasing[4]);
		
		groupNameTag = ("vehicleInspectorSettings.simple.ownPosition.attention(%d)"):format(0);
		setXMLString(Xml, groupNameTag.. "#info", "!! Mod check not up/down/left/right correct Display Position/lenght/width/height (helpMeneOn/Off etc. is active) !! Wait next Update for more");
		groupNameTag = ("vehicleInspectorSettings.simple.ownPosition.isOn(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#boolean", VehicleInspector.simple.ownPos.isOn);
		groupNameTag = ("vehicleInspectorSettings.simple.ownPosition.posX(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#float", VehicleInspector.simple.ownPos.x);
		groupNameTag = ("vehicleInspectorSettings.simple.ownPosition.posY(%d)"):format(0);
		setXMLFloat(Xml, groupNameTag.. "#float", VehicleInspector.simple.ownPos.y);
		
		saveXMLFile(Xml);
	else
		Xml = loadXMLFile("VehicleInspector_XML", file, "vehicleInspectorSettings");
		local groupNameTag = ("vehicleInspectorSettings.simple.version(%d)"):format(0);
		if not getXMLString(Xml, groupNameTag.. "#xmlVersion") then VehicleInspector:saveOldXml();VehicleInspector:setGetCfg(false)return;end;
		local xmlVersionTemp = string.format("%1.1f", "".. getXMLString(Xml, groupNameTag.. "#xmlVersion"));		
		if tonumber(xmlVersionTemp) < tonumber(xmlVersion) then VehicleInspector:saveOldXml();VehicleInspector:setGetCfg(false)return;end;
		
		local groupNameTag = ("vehicleInspectorSettings.simple.NO_SUPPORT_TEST.isTest(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isSelectVehicle = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		if not VehicleInspector.simple.isSelectVehicle then VehicleInspector.simple.isDraw.modus = 0;end;
		
		local groupNameTag = ("vehicleInspectorSettings.simple.global(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#isOn") ~= nil then VehicleInspector.simple.isOn = getXMLBool(Xml, groupNameTag.. "#isOn");end;
		if getXMLBool(Xml, groupNameTag.. "#rebootXmlESC") ~= nil then VehicleInspector.simple.rebootXml = getXMLBool(Xml, groupNameTag.. "#rebootXmlESC");end;		
		if getXMLFloat(Xml, groupNameTag.. "#posX") then VehicleInspector.simple.defaultPosX = getXMLFloat(Xml, groupNameTag.. "#posX");end;
		if getXMLFloat(Xml, groupNameTag.. "#posY") then VehicleInspector.simple.defaultPosY = getXMLFloat(Xml, groupNameTag.. "#posY");end;
		--VehicleInspector.simple.tempPosY = VehicleInspector.simple.defaultPosY;
		if getXMLFloat(Xml, groupNameTag.. "#downPosX") then VehicleInspector.simple.defaultDownPosX = getXMLFloat(Xml, groupNameTag.. "#downPosX");end;
		if getXMLFloat(Xml, groupNameTag.. "#downPosY") then VehicleInspector.simple.defaultDownPosY = getXMLFloat(Xml, groupNameTag.. "#downPosY");end;
		if getXMLBool(Xml, groupNameTag.. "#resetPosY") ~= nil then VehicleInspector.simple.resetPosY = getXMLBool(Xml, groupNameTag.. "#resetPosY");end;
		--VehicleInspector.simple.tempDownPosY = VehicleInspector.simple.defaultDownPosY;
		if getXMLBool(Xml, groupNameTag.. "#hlDebugMode") ~= nil then VehicleInspector.hlDebugMode = getXMLBool(Xml, groupNameTag.. "#hlDebugMode");end;	
		
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.parkingVehicleSupport(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.parkingVehicleModSupport = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.seeParkingVehicle(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeParkingVehicle = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.seeParkingVehicleMarker(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeParkingVehicleMarker = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherModSupport.joinParkingVehicle(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.joinParkingVehicle = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.posDown(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.showMod.posDown = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOn_F1(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.showMod.helpMenuOn = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOnAndInputEmpty(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.showMod.helpMenuOnAndInputEmpty = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOff_F1(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.showMod.helpMenuOff = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isHelpMenuOffAndInputEmpty(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.showMod.helpMenuOffAndInputEmpty = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isInGameMapOn(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.showMod.inGameMapOn = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showMod.isInGameMapOff(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.showMod.inGameMapOff = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.txtSize(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#float") ~= nil then VehicleInspector.simple.defaultSize = getXMLFloat(Xml, groupNameTag.. "#float");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.txtAllBold(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.allTxtBold = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.leasingTxtLast(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.leasingTxtLast = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.lineNextTxtDistancePosX(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#float") then VehicleInspector.simple.lineNextTxtDistancePosX = getXMLFloat(Xml, groupNameTag.. "#float");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.lineDistancePosY(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#float") then VehicleInspector.simple.lineDistancePosY = getXMLFloat(Xml, groupNameTag.. "#float");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.attachedLimit(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.. "#int") then VehicleInspector.simple.attachedLimit = getXMLInt(Xml, groupNameTag.. "#int");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.maxFillNameLength(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.. "#int") then VehicleInspector.simple.maxFillNameLength = getXMLInt(Xml, groupNameTag.. "#int");end;
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.maxVehicleNameLength(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.. "#int") then VehicleInspector.simple.maxVehicleNameLength = getXMLInt(Xml, groupNameTag.. "#int");end;
		
		--check is old or new xml structure v1.43, later remove
		local searchInvertTemp = "";		
		groupNameTag = ("vehicleInspectorSettings.simple.otherValues.searchInvertColorByVehicleTypeName(%d)"):format(0);
		local groupNameTagOld = ("vehicleInspectorSettings.simple.other(%d)"):format(0);
		if groupNameTagOld ~= nil and getXMLString(Xml, groupNameTagOld.. "#searchInvert") ~= nil then searchInvertTemp = getXMLString(Xml, groupNameTagOld.. "#searchInvert");		
		elseif getXMLString(Xml, groupNameTag.. "#stringWithCommaseparator") ~= nil then searchInvertTemp = getXMLString(Xml, groupNameTag.. "#stringWithCommaseparator");end;
		local stringSplit = VehicleInspector:get_hl("stringSplit", {searchInvertTemp, ","}, "XML Load searchInvert"); --VehicleInspector:stringSplit(searchInvertTemp, ",");
		if stringSplit ~= nil and #stringSplit > 0 then
			searchInvertTemp = ",";			
			VehicleInspector.simple.searchInvert = {};
			for key,value in pairs(stringSplit) do				
				if VehicleInspector.simple.searchInvert[key] == nil then table.insert(VehicleInspector.simple.searchInvert, tostring(string.lower(stringSplit[key])));end;
				searchInvertTemp = searchInvertTemp.. tostring(string.lower(stringSplit[key])).. ",";
			end;			
		end;

		
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isFillFull(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isFillFull = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isTrain(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isTrain = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isPlayer(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isPlayer = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isHorsePlayer(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isHorsePlayer = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isHelper(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isHelper = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.ownFarmVehicle(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.ownFarmVehicle = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showVehicle.isFillLevel(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isFillLevel = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seePlayerFirst(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seePlayerFirst = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeHelperFirst(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeHelperFirst = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeHelperName(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeHelperName = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeField(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeField = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeFieldNumber(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeFieldNumber = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeSpeed(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeSpeed = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeFillName(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeFillName = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeRealFillName(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeRealFillName = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeFillLevel(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeFillLevel = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeProzent(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeProzent = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seePlayerName(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seePlayerName = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeVehicleName(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeVehicleName = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeVehicleSmallName(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeVehicleSmallName = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeVehicleTypeName(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeVehicleTypeName = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.seeLastTotalAttached(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeLastTotalAttached = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isBlocking(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isBlocking = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isDamage(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isDamage = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isWater(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isWater = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isFuel(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isFuel = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.showTxtOr.isLeasing(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.isLeasing = getXMLBool(Xml, groupNameTag.. "#boolean");end;
								
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.defaultseparator(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.separator = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.fillNameToFillLevelseparator(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.fillNameToFillLevel = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSpeed(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.speed = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isField(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.field = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isHorse(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.horse = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isTrain(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherT = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isHelper(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.helperS = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isPlayer(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.playerS = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSeeds(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherSa = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSeedsEmpty(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherSaEmpty = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isSeedsOrFill(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherSaOrFill = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isWater(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherW = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isDamage(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherD = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isBlocking(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherB = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isLeasing(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherL = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isFull(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherFull = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.separatorAndTxt.isFuelEmty(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.otherFuelEmpty = getXMLString(Xml, groupNameTag.. "#txt");end;		
		
		groupNameTag = ("vehicleInspectorSettings.simple.horse.horseTxtWarningColor(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.horseWarningColor = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseHealth(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeHorseHealth = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.healthTxt(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.horseHealth = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseFitness(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeHorseFitness = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.fitnessTxt(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.horseFitness = getXMLString(Xml, groupNameTag.. "#txt");end;		
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseCare(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeHorseCare = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.careTxt(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.horseCare = getXMLString(Xml, groupNameTag.. "#txt");end;		
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseTodayRiding(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeHorseTodayRiding = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.todayRidingTxt(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.horseTodayRiding = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.todayRidingHourTxt(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.horseTodayRidingHour = getXMLString(Xml, groupNameTag.. "#txt");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.seeHorseDayRiding(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.seeHorseDayRiding = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.horse.dayRidingTxt(%d)"):format(0);
		if getXMLString(Xml, groupNameTag.. "#txt") ~= nil then VehicleInspector.simple.txt.horseDayRiding = getXMLString(Xml, groupNameTag.. "#txt");end;
		
		groupNameTag = ("vehicleInspectorSettings.simple.colors.seeBackground(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.color.seeBackground = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isBackground(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.isBackground = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.defaultTxt(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.default = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;		
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_0-24Fill(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.prozent[1] = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_76-100Seeds(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.prozent[2] = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_25-49(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.prozent[3] = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_50-74(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.prozent[4] = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_75-94(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.prozent[5] = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_95-99(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.prozent[6] = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.prozent_100(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.prozent[7] = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;		
		groupNameTag = ("vehicleInspectorSettings.simple.colors.playerControlled(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.playerControlled = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.anotherPlayerControlled(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.anotherPlayerControlled = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isFieldTxt(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.isField = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isWaterTxt(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.isWater = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isDamageTxt(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.isDamage = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isBlockingTxt(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.isBlocking = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		groupNameTag = ("vehicleInspectorSettings.simple.colors.isLeasingTxt(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#red") and getXMLFloat(Xml, groupNameTag.. "#green") and getXMLFloat(Xml, groupNameTag.. "#blue") and getXMLFloat(Xml, groupNameTag.. "#alpha") then 
			VehicleInspector.simple.color.isLeasing = {getXMLFloat(Xml, groupNameTag.. "#red"),getXMLFloat(Xml, groupNameTag.. "#green"),getXMLFloat(Xml, groupNameTag.. "#blue"),getXMLFloat(Xml, groupNameTag.. "#alpha")};
		end;
		
		groupNameTag = ("vehicleInspectorSettings.simple.ownPosition.isOn(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then VehicleInspector.simple.ownPos.isOn = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("vehicleInspectorSettings.simple.ownPosition.posX(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#float") then VehicleInspector.simple.ownPos.x = getXMLFloat(Xml, groupNameTag.. "#float");end;
		groupNameTag = ("vehicleInspectorSettings.simple.ownPosition.posY(%d)"):format(0);
		if getXMLFloat(Xml, groupNameTag.. "#float") then VehicleInspector.simple.ownPos.y = getXMLFloat(Xml, groupNameTag.. "#float");end;
		if VehicleInspector.simple.color.seeBackground then VehicleInspector:setBackgroundColor(VehicleInspector.overlays["ground"], VehicleInspector.simple.color.isBackground);end;
	end;
end;

function VehicleInspector:saveOldXml()	
	local getDateString = tostring(getDate("%d").. "_".. getDate("%w").. "_".. getDate("%m").. "_".. getDate("%Y"));
	local oldXml = VehicleInspector.settingsDir.. "vehicleInspectorSettings.xml";	
	local backupXml = VehicleInspector.settingsDir.. "vehicleInspectorSettings_Old_Backup_".. getDateString.. ".xml";	
	copyFile(oldXml, backupXml, false);
end;