--
--
-- SpeedControl
--
-- # Author:  Heady
-- # date: 17.02.2015
-- # update LS17: 28.10.2016
-- # update LS19: 19.01.2019
-- # last update: 08.05.2020
--
-- > Not for commercial use  < --
-- > Not allowed for edit - Copyright (C) Heady - www.planet-ls.de < --
--


SpeedControl = {};

local modDir = g_currentModDirectory;

function SpeedControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Enterable, specializations) and SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SpeedControl.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad"
		,"onPostLoad"
		,"onDelete"
		,"saveToXMLFile"
		,"onRegisterActionEvents"
		,"onReadStream"
		,"onWriteStream"
		,"onUpdate"
		,"onUpdateTick"
		,"onDraw"
	};
	
	for i, v in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, v, SpeedControl);
	end;
end;

function SpeedControl:onLoad(savegame)	
	self.setSpeedControlKey = SpeedControl.setSpeedControlKey;
	self.setSpeedControl = SpeedControl.setSpeedControl;
	self.setCruiseControlState = Utils.appendedFunction(Drivable.setCruiseControlState, SpeedControl.setCruiseControlState);
	
	
	self.speedControl = {};
	self.spec_speedControl = self.speedControl;

	self.speedControl.KeyPosX = 0;
	self.speedControl.KeyPosY = 0;
	self.speedControl.KeyTextSize = 1;
	
	self.speedControl.actionEvents = {};
	self.speedControl.inputValues = {};
	self.speedControl.inputValues.axisSteer = 0;
	self.speedControl.actionEventIds = {};	

	self.speedControl.keys = {};
	self.speedControl.keys[1] = {};
	self.speedControl.keys[1].speed = 10;
	self.speedControl.keys[1].isActive = false;
	self.speedControl.keys[1].isSelected = false;

	self.speedControl.keys[2] = {};
	self.speedControl.keys[2].speed = 20;
	self.speedControl.keys[2].isActive = false;
	self.speedControl.keys[2].isSelected = false;

	self.speedControl.keys[3] = {};
	local motor = self:getMotor();
	self.speedControl.keys[3].speed = math.ceil(motor:getMaximumForwardSpeed()*3.6);
	self.speedControl.keys[3].isActive = false;
	self.speedControl.keys[3].isSelected = true;

	self.speedControl.currentKey = 3;
	
	self.speedControl.changeWaitTime = 0;
	
end;

function SpeedControl:onPostLoad(savegame)
	
	if savegame ~= nil then
		local val1 = getXMLInt(savegame.xmlFile, savegame.key..".SpeedControl#speed1")
		if val1 ~= nil then
			self.speedControl.keys[1].speed = val1;
		end;
		local val2 = getXMLInt(savegame.xmlFile, savegame.key..".SpeedControl#speed2")
		if val2~= nil then
			self.speedControl.keys[2].speed = val2;
		end;
		local val3 = getXMLInt(savegame.xmlFile, savegame.key..".SpeedControl#speed3")
		if val3 ~= nil then
			self.speedControl.keys[3].speed = val3;
		end;
		local val4 = getXMLInt(savegame.xmlFile, savegame.key..".SpeedControl#currentKey")
		if val4 ~= nil then
			self.speedControl.currentKey = val4;
			self.speedControl.keys[val4].isSelected = true;
		end;
	end;
	
	if self.spec_drivable.cruiseControl ~= nil then
	
		self.spec_drivable.cruiseControl.isActive = false;
		self.spec_drivable.cruiseControl.speed = self.speedControl.keys[self.speedControl.currentKey].speed;
		
	end;

	
end;

function SpeedControl:onDelete()
end;

function SpeedControl:saveToXMLFile(xmlFile, key)

	setXMLInt(xmlFile, key.."#speed1",    math.ceil(self.speedControl.keys[1].speed));
	setXMLInt(xmlFile, key.."#speed2",    math.ceil(self.speedControl.keys[2].speed));
	setXMLInt(xmlFile, key.."#speed3",    math.ceil(self.speedControl.keys[3].speed));
	setXMLInt(xmlFile, key.."#currentKey", self.speedControl.currentKey);

end;

function SpeedControl:onRegisterActionEvents(isActiveForInput)



    if self.isClient then
			local spec = self.speedControl;
			self:clearActionEventsTable(spec.actionEvents);
			spec.actionEventIds = {};
			
		if self:getIsActiveForInput(true, true) then

            local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_SPEED1", self, SpeedControl.onInputAction, false, true, false, true, nil);
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
            g_inputBinding:setActionEventTextVisibility(actionEventId, true);
			table.insert(spec.actionEventIds, actionEventId);
			
			if actionEventId == "" then
				local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_SPEED1", self, SpeedControl.onInputAction, false, true, false, true, nil);
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
				g_inputBinding:setActionEventTextVisibility(actionEventId, true);
				table.insert(spec.actionEventIds, actionEventId);
			end;
			
			local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_SPEED2", self, SpeedControl.onInputAction, false, true, false, true, nil);
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
            g_inputBinding:setActionEventTextVisibility(actionEventId, true);
			table.insert(spec.actionEventIds, actionEventId);
			
			if actionEventId == "" then
				local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_SPEED2", self, SpeedControl.onInputAction, false, true, false, true, nil);
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
				g_inputBinding:setActionEventTextVisibility(actionEventId, true);
				table.insert(spec.actionEventIds, actionEventId);
			end;
			
			local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_SPEED3", self, SpeedControl.onInputAction, false, true, false, true, nil);
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
			g_inputBinding:setActionEventTextVisibility(actionEventId, true);
			table.insert(spec.actionEventIds, actionEventId);
			
			if actionEventId == "" then
				local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_SPEED3", self, SpeedControl.onInputAction, false, true, false, true, nil);
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
				g_inputBinding:setActionEventTextVisibility(actionEventId, true);
				table.insert(spec.actionEventIds, actionEventId);
			end;
			
			local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_AXIS_SETSPEED", self, SpeedControl.onInputAction_setSpeed, false, false, true, true, nil);			
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
            g_inputBinding:setActionEventTextVisibility(actionEventId, true);
			table.insert(spec.actionEventIds, actionEventId);
			
			if actionEventId == "" then
				local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_AXIS_SETSPEED", self, SpeedControl.onInputAction_setSpeed, false, false, true, true, nil);			
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
				g_inputBinding:setActionEventTextVisibility(actionEventId, true);
				table.insert(spec.actionEventIds, actionEventId);
			end;
			
			local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_AXIS_SETSPEED", self, SpeedControl.onInputAction_setSpeedEvent, false, true, false, true, nil);
			table.insert(spec.actionEventIds, actionEventId);
			
			if actionEventId == "" then
				local _, actionEventId = self:addActionEvent(spec.actionEvents, "SPEEDCONTROL_AXIS_SETSPEED", self, SpeedControl.onInputAction_setSpeedEvent, false, true, false, true, nil);
				table.insert(spec.actionEventIds, actionEventId);
			end;

        end;
    end;
end;

function SpeedControl.onInputAction(self, actionName, inputValue, callbackState, isAnalog)

	if actionName == "SPEEDCONTROL_SPEED1" then
		self.speedControl.currentKey = 1;
		self:setSpeedControlKey(1);
		SpeedControlMPEvent:updateSendEvent(self);
	end;
	if actionName == "SPEEDCONTROL_SPEED2" then
		self.speedControl.currentKey = 2;
		self:setSpeedControlKey(2);
		SpeedControlMPEvent:updateSendEvent(self);
	end;
	if actionName == "SPEEDCONTROL_SPEED3" then
		self.speedControl.currentKey = 3;
		self:setSpeedControlKey(3);
		SpeedControlMPEvent:updateSendEvent(self);
	end;
	
	self.spec_drivable.cruiseControl.speed = math.ceil(self.speedControl.keys[self.speedControl.currentKey].speed);
	SpeedControlSpeedMPEvent:updateSendEvent(self);
	
end;

function SpeedControl.onInputAction_setSpeed(self, actionName, inputValue, callbackState, isAnalog)

    if self:getIsEntered() then
        self.speedControl.inputValues.axisSteer = inputValue;
    end;
	
end;

function SpeedControl.onInputAction_setSpeedEvent(self, actionName, inputValue, callbackState, isAnalog)

    if self:getIsEntered() then
		if inputValue < 0 and self.speedControl.keys[self.speedControl.currentKey].speed > 0 then
			self.speedControl.keys[self.speedControl.currentKey].speed = self.speedControl.keys[self.speedControl.currentKey].speed - 1;
		elseif inputValue > 0 and self.speedControl.keys[self.speedControl.currentKey].speed < math.ceil(self:getMotor():getMaximumForwardSpeed()*3.6) then
			self.speedControl.keys[self.speedControl.currentKey].speed = self.speedControl.keys[self.speedControl.currentKey].speed + 1;
		end;
    end;
	
	self.spec_drivable.cruiseControl.speed = math.ceil(self.speedControl.keys[self.speedControl.currentKey].speed);
	SpeedControlSpeedMPEvent:updateSendEvent(self);	
	
end;

function SpeedControl:onReadStream(streamId, connection)
    if connection:getIsServer() then
        self.speedControl.currentKey = streamReadInt8(streamId);

		self.speedControl.keys[1].isSelected = streamReadBool(streamId);
		self.speedControl.keys[1].isActive = streamReadBool(streamId);
		self.speedControl.keys[1].speed = streamReadInt8(streamId);
		
		self.speedControl.keys[2].isSelected = streamReadBool(streamId);
		self.speedControl.keys[2].isActive = streamReadBool(streamId);
		self.speedControl.keys[2].speed = streamReadInt8(streamId);
		
		self.speedControl.keys[3].isSelected = streamReadBool(streamId);
		self.speedControl.keys[3].isActive = streamReadBool(streamId);
		self.speedControl.keys[3].speed = streamReadInt8(streamId);
		
		self.spec_drivable.cruiseControl.speed = math.ceil(self.speedControl.keys[self.speedControl.currentKey].speed);
    end;
end;

function SpeedControl:onWriteStream(streamId, connection)
    if not connection:getIsServer() then
        streamWriteInt8(streamId, self.speedControl.currentKey);
		
		streamWriteBool(streamId, self.speedControl.keys[1].isSelected);
		streamWriteBool(streamId, self.speedControl.keys[1].isActive);
		streamWriteInt8(streamId, self.speedControl.keys[1].speed);
		
		streamWriteBool(streamId, self.speedControl.keys[2].isSelected);
		streamWriteBool(streamId, self.speedControl.keys[2].isActive);
		streamWriteInt8(streamId, self.speedControl.keys[2].speed);
		
		streamWriteBool(streamId, self.speedControl.keys[3].isSelected);
		streamWriteBool(streamId, self.speedControl.keys[3].isActive);
		streamWriteInt8(streamId, self.speedControl.keys[3].speed);
    end;
end;

function SpeedControl:onUpdate(dt)

	local spec = self.spec_enterable
	if spec.isEntered and self.isClient then
			
		local currSpeed = self.speedControl.keys[self.speedControl.currentKey].speed;			
		
		if self.speedControl.inputValues.axisSteer < 0 and self.speedControl.keys[self.speedControl.currentKey].speed > 0 then
			self.speedControl.changeWaitTime = self.speedControl.changeWaitTime + dt; -- realtime ms
			if self.speedControl.changeWaitTime > 250 then
				self.speedControl.keys[self.speedControl.currentKey].speed = self.speedControl.keys[self.speedControl.currentKey].speed - 15*dt/1000
			end;

			if self.speedControl.keys[self.speedControl.currentKey].speed < 1 then
				self.speedControl.keys[self.speedControl.currentKey].speed = 1;
			end;

		elseif self.speedControl.inputValues.axisSteer > 0 and self.speedControl.keys[self.speedControl.currentKey].speed < math.ceil(self:getMotor():getMaximumForwardSpeed()*3.6) then				
			self.speedControl.changeWaitTime = self.speedControl.changeWaitTime + dt; -- realtime ms
			if self.speedControl.changeWaitTime > 250 then
				self.speedControl.keys[self.speedControl.currentKey].speed = self.speedControl.keys[self.speedControl.currentKey].speed + 15*dt/1000
			end;
			
			if self.speedControl.keys[self.speedControl.currentKey].speed > math.ceil(self:getMotor():getMaximumForwardSpeed()*3.6) then
				self.speedControl.keys[self.speedControl.currentKey].speed = math.ceil(self:getMotor():getMaximumForwardSpeed()*3.6);
			end;
		else
			self.speedControl.changeWaitTime = 0;
		end;		
		
		if self.speedControl.keys[self.speedControl.currentKey].speed ~= currSpeed then		
			self.spec_drivable.cruiseControl.speed = math.ceil(self.speedControl.keys[self.speedControl.currentKey].speed);
			SpeedControlSpeedMPEvent:updateSendEvent(self);				
		end;
			
	end;

end;

function SpeedControl:onUpdateTick(dt)

end;

function SpeedControl:onDraw()

	if self.spec_enterable.isEntered then
		
		local cruiseOverlay = g_currentMission.inGameMenu.hud.speedMeter.cruiseControlElement.overlay;	
		self.speedControl.KeyPosX = cruiseOverlay.x + cruiseOverlay.width * 0.8;
		self.speedControl.KeyPosY = cruiseOverlay.y + cruiseOverlay.height * 0.8;
		self.speedControl.KeyTextSize = g_currentMission.inGameMenu.hud.speedMeter.cruiseControlTextSize * 0.55;

		if self.spec_drivable.cruiseControl.state == 1 then
			--setTextColor(0.2, 0.83, 0, 1);
			setTextColor(0.98, 0.4, 0, 1);
		else
			setTextColor(1,1,1,1);
		end;
		setTextBold(true);
		setTextAlignment(RenderText.ALIGN_LEFT);
		renderText(self.speedControl.KeyPosX, self.speedControl.KeyPosY, self.speedControl.KeyTextSize, tostring(self.speedControl.currentKey));
		
		setTextColor(1,1,1,1);
		setTextBold(false);
		--setTextAlignment(RenderText.ALIGN_LEFT)

	end;	

end;

function SpeedControl:setSpeedControlKey(key)


	if not self.speedControl.keys[key].isSelected then
		for i=1, table.getn(self.speedControl.keys) do
			self.speedControl.keys[i].isSelected = false;	
		end;
		self.speedControl.keys[key].isSelected = true;
		
		local isKeyActive = false;
		for i=1, table.getn(self.speedControl.keys) do
			if self.speedControl.keys[i].isActive then
				isKeyActive = true;
			end;
		end;
		if isKeyActive then
			for i=1, table.getn(self.speedControl.keys) do
				self.speedControl.keys[i].isActive = false;	
			end;
			self.speedControl.keys[key].isActive = true;				
			self:setSpeedControl(key, true);
		end;
	else
		if self.speedControl.keys[key].isActive then
			self.speedControl.keys[key].isActive = false;
			self:setSpeedControl(key, false);
			return;
		end;
		for i=1, table.getn(self.speedControl.keys) do
			self.speedControl.keys[i].isActive = false;	
		end;
		self.speedControl.keys[key].isActive = true;
		self.speedControl.keys[key].isSelected = true;		
		self:setSpeedControl(key, true);
	end;




	--[[self.speedControl.keys[i].isSelected = true;

	if self.speedControl.keys[key].isActive then
		self.speedControl.keys[key].isActive = false;
		
		self:setSpeedControl(key, false);
	else
		local isKeyActive = false;
			for i=1, table.getn(self.speedControl.keys) do
				if self.speedControl.keys[i].isActive then
					isKeyActive = true;
				end;
			end;
			if not isKeyActive then
				for i=1, table.getn(self.speedControl.keys) do
					self.speedControl.keys[i].isActive = false;	
				end;
				self.speedControl.keys[key].isActive = true;			
				self:setSpeedControl(key, true);
			end;
		if self.speedControl.keys[key].isSelected then
			self.speedControl.keys[key].isActive = true;
			
			self:setSpeedControl(key, true);
		else
			for i=1, table.getn(self.speedControl.keys) do
				self.speedControl.keys[i].isSelected = false;	
			end;
			for i=1, table.getn(self.speedControl.keys) do
				self.speedControl.keys[i].isActive = false;	
			end;
			self.speedControl.keys[key].isSelected = true;	
			
			self:setSpeedControl(key, false);
		end;
	end;--]]

end;

function SpeedControl:setSpeedControl(key, active)

	if active then
		self.spec_drivable.cruiseControl.state = 1;
		self:getMotor():setSpeedLimit(self.spec_drivable.cruiseControl.speed);
	else
		self.spec_drivable.cruiseControl.state = 0;
		self:getMotor():setSpeedLimit(math.huge);
	end;

end;

function SpeedControl:setCruiseControlState(state, noEventSend)

	for i=1, table.getn(self.speedControl.keys) do
		self.speedControl.keys[i].isActive = false;	
	end;
	
end;


SpeedControlMPEvent = {};
SpeedControlMPEvent_mt = Class(SpeedControlMPEvent, Event);

InitEventClass(SpeedControlMPEvent, "SpeedControlMPEvent");

function SpeedControlMPEvent:emptyNew()
    local self = Event:new(SpeedControlMPEvent_mt);
    self.className="SpeedControlMPEvent";
    return self;
end;

function SpeedControlMPEvent:new(object)
    local self = SpeedControlMPEvent:emptyNew()
    self.object = object;
    return self;
end;

function SpeedControlMPEvent:readStream(streamId, connection)	
    self.object = NetworkUtil.readNodeObject(streamId);	
	
	self.object.speedControl.currentKey = streamReadInt8(streamId);
	
	self.object:setSpeedControlKey(self.object.speedControl.currentKey);
	
	if not connection:getIsServer() then -- if server read then send to clients
		g_server:broadcastEvent(SpeedControlMPEvent:new(self.object), nil, connection, self.object);
	end;

end;

function SpeedControlMPEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object);	
	
	streamWriteInt8(streamId, self.object.speedControl.currentKey);	
end;

function SpeedControlMPEvent:updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(SpeedControlMPEvent:new(runSelf));
	else
		g_client:getServerConnection():sendEvent(SpeedControlMPEvent:new(runSelf));
	end;

end;

SpeedControlSpeedMPEvent = {};
SpeedControlSpeedMPEvent_mt = Class(SpeedControlSpeedMPEvent, Event);

InitEventClass(SpeedControlSpeedMPEvent, "SpeedControlSpeedMPEvent");

function SpeedControlSpeedMPEvent:emptyNew()
    local self = Event:new(SpeedControlSpeedMPEvent_mt);
    self.className="SpeedControlSpeedMPEvent";
    return self;
end;

function SpeedControlSpeedMPEvent:new(object)
    local self = SpeedControlSpeedMPEvent:emptyNew()
    self.object = object;
    return self;
end;

function SpeedControlSpeedMPEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId);	
	
	self.object.speedControl.keys[self.object.speedControl.currentKey].speed = streamReadInt8(streamId);
	
	self.object.spec_drivable.cruiseControl.speed = math.ceil(self.object.speedControl.keys[self.object.speedControl.currentKey].speed);
	
	if not connection:getIsServer() then -- if server read then send to clients
		g_server:broadcastEvent(SpeedControlSpeedMPEvent:new(self.object), nil, connection, self.object);
	end;

end;

function SpeedControlSpeedMPEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object);		
	
	streamWriteInt8(streamId, self.object.speedControl.keys[self.object.speedControl.currentKey].speed);
end;

function SpeedControlSpeedMPEvent:updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(SpeedControlSpeedMPEvent:new(runSelf));
	else
		g_client:getServerConnection():sendEvent(SpeedControlSpeedMPEvent:new(runSelf));
	end;

end;


