--[[

Game:	Farming Simulator 19
Title:	InfoMenu - from UnitConvert Lite
Author:	ThundR-Grouminait

Allows Farming Simulator 19 to display different units of measurement
Slimmed version of the UnitExtension (possibly DisplayExtension) app for HarvestMaster

TODO:
	- Add the toggle inputBinding for switching units (In Progress --- think of something besides currentVehicleUnit)
	- Create conversion function(s)

--]]

-- [Declarations] ***********************************************************************************************************************************

g_modName = g_currentModName
g_modDesc = g_modManager:getModByName(g_modName)
g_modPath = g_modDesc.modDir
g_modFile = g_modDesc.modFile

InfoMenu = {}

-- L10n Constant(s)
InfoMenu.L10N_PREFIX = "im_"

-- Message Constants

g_infoMenu = {}
g_infoMenu.name = "infoMenu"
g_infoMenu.className = "InfoMenu"
g_infoMenu.debugLevel = 0

function g_infoMenu:class()
	return InfoMenu
end

setmetatable(g_infoMenu, {__index = InfoMenu})
getfenv(0).g_infoMenu = g_infoMenu

-- [Extra Source Files] *****************************************************************************************************************************

source(g_modPath.."scripts/Utils.lua")
source(g_modPath.."scripts/InGameMenu.lua")

-- [Events] *****************************************************************************************************************************************

function InfoMenu:onInitialize(...)
	-- Initialize InGameMenu features
	self:initializeInGameMenu()

end

function InfoMenu:onLoadMapFinished(...)
	if DebugTools then
		--DebugTools:printTable(self, 4, true) -- Check internal tables
	end
end

-- [Base Functions] *********************************************************************************************************************************

function InfoMenu:getLocalText(text, ...)
-- Returns a local (overridden) i18n text value
	-- [text]:  Text key (string)
	-- [...]:	Variables passed to string.format function (any) > Optional

	return HMUtils.getText(InfoMenu.L10N_PREFIX..text, ...)
end

function InfoMenu:getMsg(msg)
-- Returns a saved log message
-- Calls HMUtils.getMsg() if not found
	-- [msg]: Message to retrieve

	if not HMUtils.isString(msg) then
		return
	end

	msg = HMUtils.upperCase(msg)
	return Utils.getNoNil(InfoMenu.MSG[msg], HMUtils.getMsg(msg))
end

-- Application Start
g_infoMenu:onInitialize()