--[[

Game:	Farming Simulator 19
Title:	InfoMenu - from UnitConvert Lite (InGameMenu)
Author:	ThundR - Grouminait

--]]

-- [Declarations] ***********************************************************************************************************************************

InfoMenu.InGameMenuMapFrame = {}
InfoMenu.InGameMenuPricesFrame = {}
InfoMenu.InGameMenuStatisticsFrame = {}

-- [Initialization] *********************************************************************************************************************************

function InfoMenu:initializeInGameMenu()
-- Initializes InGameMenu

	-- InGameMenuMapFrame overrides
	HMUtils.setFunction(self, "InGameMenuMapFrame", "onFrameOpen")
	HMUtils.setFunction(self, "InGameMenuMapFrame", "generateFarmlandOverlay")

	-- InGameMenuPricesFrame overrides
	HMUtils.setFunction(self, "InGameMenuPricesFrame", "updatePriceTable")

end

-- [InGameMenuMapFrame Overrides] *******************************************************************************************************************

function InfoMenu.InGameMenuMapFrame:onFrameOpen(...)
	local savedFunc = HMUtils.getSavedFunction(g_infoMenu, "InGameMenuMapFrame.onFrameOpen")

	self.InfoMenu = Utils.getNoNil(self.InfoMenu, {})

	if not self.InfoMenu.initialized then
		local farmlandBalanceParent = self.balanceText.parent
		local farmlandValueParent = self.farmlandValueText.parent
		local farmlandAreaElement = farmlandValueParent:clone(self.farmlandValueBox)
		local farmlandOwnerElement = farmlandValueParent:clone(self.farmlandValueBox)
		local fieldAreaElement = farmlandValueParent:clone(self.farmlandValueBox)

		-- Owner element
		local parentX, parentY = HMUtils.unpack(farmlandBalanceParent.position)
		local parentWidth, parentHeight = HMUtils.unpack(farmlandBalanceParent.size)
		farmlandOwnerElement:updateScreenAlign("middleLeft")
		farmlandOwnerElement:updatePositionForOrigin("middleLeft")
		farmlandOwnerElement:setPosition(parentX, parentY + (2*parentHeight))
		farmlandOwnerElement.elements[1]:setText(g_infoMenu:getLocalText("ui_owner")..":")
		self.farmlandOwnerElement = farmlandOwnerElement
		self.farmlandOwnerText = farmlandOwnerElement.elements[2]

		-- Land Area element
		local parentX, parentY = HMUtils.unpack(farmlandBalanceParent.position)
		local parentWidth, parentHeight = HMUtils.unpack(farmlandBalanceParent.size)
        farmlandAreaElement:updateScreenAlign("middleLeft")
		farmlandAreaElement:updatePositionForOrigin("middleLeft")
		farmlandAreaElement:setPosition(parentX, parentY + parentHeight)
		farmlandAreaElement.elements[1]:setText(g_infoMenu:getLocalText("ui_landArea")..":")
		self.farmlandAreaElement = farmlandAreaElement
		self.farmlandAreaText = farmlandAreaElement.elements[2]
		
		-- Fields Area element
		local parentX, parentY = HMUtils.unpack(farmlandValueParent.position)
		local parentWidth, parentHeight = HMUtils.unpack(farmlandValueParent.size)
		fieldAreaElement:setPosition(parentX , parentY + parentHeight)
		fieldAreaElement.elements[1]:setText(g_infoMenu:getLocalText("ui_fieldArea")..":")
		self.fieldAreaElement = fieldAreaElement
		self.fieldAreaText = fieldAreaElement.elements[2]

		self.InfoMenu.initialized = true
	end

	local ret = HMUtils.pack(savedFunc(self, ...))
	return HMUtils.unpack(ret)
end

function InfoMenu.InGameMenuMapFrame:generateFarmlandOverlay(...)
	local savedFunc = HMUtils.getSavedFunction(g_infoMenu, "InGameMenuMapFrame.generateFarmlandOverlay")
	local ret = HMUtils.pack(savedFunc(self, ...))

	local ownerText = ""

	local selectedFarmland = self.selectedFarmland
	if selectedFarmland then
		-- Owner name
		local npcIndex = g_npcManager:getNPCByIndex(tonumber(selectedFarmland.npcIndex))
		if selectedFarmland.isOwned then
			ownerText = HMUtils.getText("ui_playerCharacter")
		elseif npcIndex then
			ownerText = npcIndex.title
		end
		self.farmlandOwnerText:setText(ownerText)
		
		-- Land area
        if (selectedFarmland.areaInHa > 0.) then
            local landPricePerArea = selectedFarmland.price / g_i18n:getArea(selectedFarmland.areaInHa)
            self.farmlandAreaText:setText(string.format("%s (%s/%s)", g_i18n:formatArea(selectedFarmland.areaInHa, 2), g_i18n:formatMoney(landPricePerArea, 0), tostring(g_i18n:getAreaUnit())))
        else
            self.farmlandAreaText:setText(g_i18n:formatArea(selectedFarmland.areaInHa, 2))
        end
		
		-- Fields area
		local fieldAreaSum = 0.
        for _, farmLand in pairs(g_fieldManager.farmlandIdFieldMapping) do
            for fieldIndex, field in pairs(farmLand) do
                if field.farmland.id == selectedFarmland.id then
                    fieldAreaSum = fieldAreaSum + field.fieldArea
                end
            end
        end
        if (fieldAreaSum > 0.) then
            local fieldPricePerArea = selectedFarmland.price / g_i18n:getArea(fieldAreaSum)
            self.fieldAreaText:setText(string.format("%s (%s/%s)", g_i18n:formatArea(fieldAreaSum, 2), g_i18n:formatMoney(fieldPricePerArea, 0), tostring(g_i18n:getAreaUnit())))
        else
            self.fieldAreaText:setText(g_i18n:formatArea(fieldAreaSum, 2))
        end
	end

	return HMUtils.unpack(ret)
end

-- [InGameMenuPricesFrame Overrides] ****************************************************************************************************************

function InfoMenu.InGameMenuPricesFrame:updatePriceTable(...)
	local savedFunc = HMUtils.getSavedFunction(g_infoMenu, "InGameMenuPricesFrame.updatePriceTable")

	local pageTitleElement = self.mainBox.parent.elements[1].elements[2]

	-- Initialize prices menu
	if not self.ucInitialized then
		-- Create fill type name elements
		self.fillTypeNameHeaders = {}
		local tableHeaderBox = self.tableHeaderBox
		for i, element in ipairs(tableHeaderBox.elements) do
			if i > 1 then
				local fillTypeNameElement = TextElement:new(self)
				element:addElement(fillTypeNameElement)
				fillTypeNameElement:applyProfile("ingameMenuPriceRowSiloCapacityValue")
				table.insert(self.fillTypeNameHeaders, fillTypeNameElement)
			end
		end
		self.ucInitialized = true
	end

	local ret = HMUtils.pack(savedFunc(self, ...))

	local fillTypeNameHeaders = self.fillTypeNameHeaders
	local startFillType = self.startFillType

	for columnIdx = 1, self.MAX_NUM_FILLTYPES do
		local fillTypeIndex = startFillType + (columnIdx-1)
		local fillType = self.priceFillTypes[fillTypeIndex]

		local fillTypeNameHeader = fillTypeNameHeaders[columnIdx]
		if fillTypeNameHeader then
			if fillType then
				fillTypeNameHeader:setText(fillType.title) --(HMUtils.properCase(fillType.title))
				fillTypeNameHeader:setVisible(true)
			else
				fillTypeNameHeader:setText("")
				fillTypeNameHeader:setVisible(false)
			end
		end
	end
	return HMUtils.unpack(ret)
end
